set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9790285';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-7-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '043',
      '33433300',
      39,
      19.043887,
      '0110340',
      25.681745,
      6,
      2.888931,
      2,
      '020224',
      4.087480,
      ' 7- 4-2000',
      NULL,
      10.128689,
      1,
      NULL,
      5.585531,
      1,
      NULL,
      NULL,
      1.343183,
      0,
      0.549015,
      3.449099,
      1.733139,
      0.960424,
      2,
      NULL,
      1.578677,
      NULL,
      1,
      1.925092,
      5,
      0.635040,
      1.896018,
      NULL,
      1.118126,
      0,
      3.055053,
      1,
      0,
      0.936189,
      0,
      0.339502,
      NULL,
      NULL,
      1.764035,
      NULL,
      NULL,
      NULL,
      0.897669,
      NULL,
      0.944837,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.676541,
      NULL,
      NULL,
      0,
      NULL,
      1.837927,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.130958,
      0,
      1.090491,
      NULL,
      1,
      0,
      0,
      1.396770,
      0.686606,
      0,
      0.095658,
      NULL,
      1.507429,
      NULL,
      1,
      0.013787,
      NULL,
      1,
      1.955708,
      NULL,
      NULL,
      1.975592,
      0,
      2,
      0,
      1,
      0,
      1.146324,
      1,
      1,
      NULL,
      0.429027,
      1,
      1.221640,
      2,
      2,
      5,
      2.760867,
      2.344040,
      5.379577,
      4,
      5,
      0,
      1.872072,
      0,
      0,
      NULL,
      NULL,
      6.023267,
      1.778320,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      1.984440,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.408936,
      NULL,
      NULL,
      NULL,
      NULL,
      3.870167,
      1.287392,
      0.674919,
      1.090058,
      0,
      0,
      0.341445,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.428293,
      NULL,
      0.287288,
      3.972429,
      0.698135,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.823961,
      1.620734,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      0.827947,
      0,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      1.225549,
      0,
      0,
      0,
      0,
      1.256021,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.399701,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '13204',
      NULL,
      '',
      0.873748,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      1.731667,
      1,
      0.736252,
      0,
      1.168687,
      0,
      NULL,
      0,
      NULL);
commit;
end;
/


