set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9790285';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-3-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '312',
      '21231103',
      NULL,
      76,
      NULL,
      6,
      3,
      3.918961,
      3,
      '214140',
      NULL,
      ' 1-19-1980',
      NULL,
      44,
      1,
      NULL,
      2.709432,
      NULL,
      2,
      0.968002,
      NULL,
      NULL,
      0.468832,
      0,
      1,
      1.342968,
      0,
      1,
      1.165030,
      0.213193,
      0,
      1.381764,
      5.944992,
      0.747758,
      1.319489,
      NULL,
      0.231517,
      1,
      3,
      1,
      1,
      0.128155,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.819371,
      1,
      0,
      0.833666,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.863158,
      3,
      NULL,
      1,
      1.397798,
      1.503792,
      NULL,
      NULL,
      1.681328,
      NULL,
      NULL,
      0.627564,
      1.371149,
      0.224678,
      0.454553,
      1.416644,
      1,
      1,
      1.445869,
      0,
      1,
      1.826468,
      0.787708,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      0,
      0.883811,
      3,
      NULL,
      0,
      3.704988,
      NULL,
      0.856166,
      0.454632,
      0.993133,
      1,
      0,
      1.567128,
      0.121434,
      0.735883,
      NULL,
      7,
      2.002400,
      NULL,
      1,
      3,
      0.031723,
      4.124402,
      3,
      NULL,
      1.585546,
      2.850647,
      0,
      NULL,
      NULL,
      8.353981,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.439872,
      NULL,
      NULL,
      0,
      0.792870,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.587680,
      NULL,
      NULL,
      NULL,
      NULL,
      2.116305,
      1.407780,
      3,
      1,
      NULL,
      NULL,
      0.541970,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.248542,
      1.092615,
      4.991812,
      NULL,
      1,
      1.982516,
      NULL,
      NULL,
      NULL,
      0,
      2.116390,
      1.811441,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.730651,
      2.043476,
      NULL,
      3.323494,
      0,
      1.656866,
      1,
      1,
      NULL,
      1,
      1.837416,
      0.429101,
      1.337231,
      0,
      0.874383,
      1,
      1,
      0,
      0.222788,
      0.350347,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.760611,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '',
      '',
      0.568899,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      1,
      0.198773,
      1,
      3,
      3.571633,
      NULL,
      NULL,
      1.163738,
      2.500382);
commit;
end;
/


