set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9790285';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-6-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2431',
      NULL,
      8.192165,
      26.859699,
      NULL,
      69,
      3,
      3.901725,
      0,
      '403430',
      NULL,
      ' 2- 3-1996',
      36.230951,
      194.610293,
      1.299468,
      NULL,
      1,
      0,
      1,
      1.938760,
      0,
      3.315840,
      0.192203,
      1,
      0,
      NULL,
      5,
      0,
      1,
      1.472302,
      NULL,
      0.411886,
      4.421089,
      0,
      1,
      NULL,
      1,
      1,
      5,
      0,
      1.129565,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.206544,
      NULL,
      NULL,
      3,
      1,
      NULL,
      1.828466,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.557129,
      0.737333,
      NULL,
      0,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      0.259102,
      NULL,
      NULL,
      NULL,
      1.113490,
      1,
      NULL,
      1,
      NULL,
      0,
      0.783485,
      0.950786,
      0.241249,
      1.391892,
      1,
      1.947220,
      1,
      1,
      1,
      1.325724,
      1,
      0,
      NULL,
      1.555220,
      0.711759,
      1.606558,
      0,
      0.656044,
      0,
      NULL,
      1,
      1,
      1.705267,
      1.539763,
      0,
      1,
      NULL,
      1,
      1,
      0.226566,
      6,
      2,
      3,
      NULL,
      5.547586,
      6,
      2.682797,
      3.714471,
      0,
      0.140456,
      1.154705,
      NULL,
      NULL,
      NULL,
      5.051302,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      0,
      NULL,
      1.721353,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.682958,
      2,
      3.264513,
      0.815062,
      0,
      1.716283,
      1.965937,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      4,
      NULL,
      2,
      0.687546,
      NULL,
      NULL,
      NULL,
      0.233732,
      0.344216,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.164039,
      1.651689,
      3,
      0,
      0,
      1,
      1,
      NULL,
      0.874492,
      NULL,
      NULL,
      0,
      0,
      0.802348,
      0.272741,
      1.536874,
      NULL,
      NULL,
      1.477231,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.888864,
      '41343',
      '',
      '',
      0.785370,
      NULL,
      NULL,
      '',
      1.525129,
      '',
      '',
      NULL,
      4.180425,
      3,
      0,
      NULL,
      0.997391,
      1.949155,
      3.498841,
      2,
      3.070774);
commit;
end;
/


