set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9790285';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-2-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '00030132',
      61,
      NULL,
      '4222012',
      64.085931,
      NULL,
      2,
      0,
      NULL,
      1,
      NULL,
      8.431043,
      56,
      0.195751,
      NULL,
      3.904874,
      1.067159,
      1,
      1.396342,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.823860,
      1.037671,
      NULL,
      1.852737,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.639007,
      NULL,
      1.053267,
      0.652547,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.705959,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      3.972352,
      NULL,
      1,
      NULL,
      0.301424,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      1.874401,
      1.786972,
      1.541716,
      1,
      NULL,
      0,
      0,
      0,
      1.856993,
      0,
      NULL,
      1.033742,
      1,
      0.950167,
      0,
      1,
      1.239431,
      NULL,
      1,
      0.407090,
      0,
      3.077494,
      NULL,
      0,
      2.346562,
      1.440475,
      0,
      1,
      1,
      1.733395,
      0.393937,
      0.675135,
      1,
      1.344364,
      1.935830,
      NULL,
      3.801896,
      NULL,
      NULL,
      6,
      NULL,
      6,
      4.646542,
      0.540519,
      0.734119,
      NULL,
      NULL,
      NULL,
      NULL,
      3.323632,
      1.410751,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.445675,
      NULL,
      1,
      1,
      0,
      0.450700,
      0.200953,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.038097,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.072872,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.188433,
      1,
      4,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.529484,
      1,
      0.848239,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.429857,
      2,
      1,
      0,
      0.794191,
      NULL,
      0.167642,
      1.893636,
      NULL,
      1,
      0.186262,
      1.605429,
      0,
      1.759581,
      0.164449,
      0.002474,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      5.091994,
      2.578317,
      0,
      1.727246,
      2,
      1.573117,
      0.155737,
      3,
      3.017927);
commit;
end;
/


