set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9790285';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-7-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2314',
      '33321223',
      73,
      15,
      '4331122',
      NULL,
      2,
      NULL,
      3,
      '342111',
      5.742534,
      ' 3- 7-1984',
      312,
      NULL,
      0.182267,
      NULL,
      2.291817,
      2.951695,
      NULL,
      1.173201,
      NULL,
      0,
      1.220593,
      NULL,
      NULL,
      1.022046,
      5,
      NULL,
      NULL,
      1,
      NULL,
      0,
      3,
      0,
      0,
      NULL,
      1,
      0,
      5.942714,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.093323,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.820337,
      0.333620,
      0,
      NULL,
      1.051454,
      0.796977,
      0,
      0.049334,
      1,
      NULL,
      0.962814,
      0.392754,
      1,
      0.524706,
      1.034122,
      0.624051,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.766900,
      0,
      1.434644,
      1,
      1.911687,
      1,
      1,
      1,
      0,
      NULL,
      0.475705,
      NULL,
      1,
      0,
      0.069954,
      4.098289,
      NULL,
      4.737716,
      2,
      5.174252,
      2,
      2,
      4.614620,
      3,
      1.068848,
      NULL,
      NULL,
      9,
      0.457080,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.410348,
      NULL,
      NULL,
      0.764837,
      3,
      0.330965,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.389495,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      4.518420,
      4,
      1.080731,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.852863,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.031546,
      2.597697,
      0.150274,
      NULL,
      1.433399,
      1.140053,
      2.753725,
      1.751090,
      2,
      NULL,
      1.591758,
      1,
      0.644421,
      NULL,
      1.387709,
      NULL,
      0.992805,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.130700,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.233200,
      '30440',
      '',
      '',
      1.175502,
      '',
      '',
      NULL,
      1,
      '',
      NULL,
      '',
      3.204221,
      1,
      2.121123,
      0.592908,
      2,
      0,
      2,
      NULL,
      0.847840);
commit;
end;
/


