set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9673213';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-12-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '134',
      '31220302',
      NULL,
      NULL,
      '1221203',
      32.540553,
      4,
      2,
      0,
      '340440',
      4.773269,
      NULL,
      259,
      31,
      1,
      NULL,
      9.928474,
      1,
      0.918892,
      1,
      NULL,
      0.754242,
      0.192177,
      2.854184,
      0,
      0,
      5.671712,
      0.004079,
      1.858739,
      1.939786,
      0.082133,
      1.147734,
      4,
      NULL,
      1,
      0.883759,
      0,
      0.509126,
      0,
      1,
      0.689489,
      1.962802,
      0,
      1,
      NULL,
      NULL,
      1.709935,
      NULL,
      NULL,
      NULL,
      1.541984,
      1,
      1.045490,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.689693,
      NULL,
      1,
      0.807368,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.080202,
      0,
      1,
      1,
      2.600707,
      1,
      NULL,
      0.175457,
      1,
      3,
      2.320151,
      2,
      1.974849,
      4,
      1.793692,
      0,
      NULL,
      0.991218,
      0,
      NULL,
      NULL,
      2,
      0,
      0.164559,
      NULL,
      1.355931,
      0.228190,
      NULL,
      0,
      0.026238,
      1.234428,
      NULL,
      0,
      1.206829,
      3.801768,
      NULL,
      2.680099,
      5,
      2.589514,
      1.025568,
      0.894400,
      5.813158,
      NULL,
      5,
      NULL,
      NULL,
      3,
      1,
      1,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      1.366182,
      3.050196,
      0.919119,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.590709,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.535712,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.896937,
      1,
      0.233652,
      1.700990,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.342693,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.716683,
      0.371446,
      NULL,
      0.031137,
      0.196169,
      NULL,
      NULL,
      0,
      1.202610,
      0.070623,
      0,
      0.673709,
      1,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      1.297807,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.190821,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.694544,
      '02443',
      '',
      '',
      1.204352,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      5.165827,
      3.030160,
      1.805331,
      3,
      2,
      2,
      1.354499,
      2.516730,
      1.966999);
commit;
end;
/


