set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9673213';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-11-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '13424202',
      53,
      NULL,
      '1003031',
      NULL,
      3,
      1.769760,
      3,
      '141203',
      0.616652,
      NULL,
      119.757150,
      24,
      0,
      NULL,
      1,
      0.062235,
      0,
      NULL,
      0,
      1.103773,
      NULL,
      3.117934,
      0,
      NULL,
      5,
      1,
      0,
      0.623826,
      NULL,
      0.983175,
      1.004206,
      0.704040,
      1,
      NULL,
      1,
      1,
      5.120623,
      NULL,
      1.276095,
      0.217049,
      1.068331,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      0.565882,
      0.019562,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.204388,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      5,
      1.334279,
      0,
      0.480633,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.069101,
      1.624281,
      1.363784,
      NULL,
      NULL,
      0,
      1.968596,
      1.049733,
      1.180571,
      1,
      2,
      5,
      NULL,
      NULL,
      0,
      0,
      0.084756,
      NULL,
      2.586768,
      NULL,
      0,
      5.887735,
      5,
      NULL,
      1,
      6,
      1.296270,
      0,
      2.012739,
      6,
      5.769786,
      3,
      NULL,
      1,
      NULL,
      NULL,
      5.597342,
      0.670249,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.275075,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      0.564765,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.109718,
      NULL,
      NULL,
      NULL,
      NULL,
      2.741104,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.834001,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.764632,
      1,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.809773,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.804255,
      3,
      3,
      1,
      1,
      0,
      3.429644,
      1,
      1.273651,
      1,
      NULL,
      NULL,
      1,
      1.966972,
      NULL,
      0.330936,
      0.006605,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.074034,
      '01430',
      '',
      '',
      0,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      2,
      0,
      2.154256,
      3.357068,
      1,
      0.720914,
      1,
      3.016188);
commit;
end;
/


