set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9673213';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-4-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '24001234',
      18.076914,
      4,
      '4001134',
      34,
      3,
      3,
      NULL,
      '030144',
      5.167739,
      ' 1-21-1995',
      110,
      62.179056,
      1,
      NULL,
      0.376963,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.978288,
      NULL,
      1.919127,
      NULL,
      NULL,
      NULL,
      0,
      0.946258,
      0,
      0,
      1,
      1,
      0.212974,
      1.444082,
      0.182258,
      1,
      3,
      1,
      0,
      NULL,
      0.347654,
      0.783542,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.572092,
      0,
      0.890522,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      5,
      1.068549,
      1.153660,
      1.387082,
      NULL,
      0.028895,
      NULL,
      0,
      4,
      1.125271,
      0,
      3,
      2.171832,
      0,
      0.576731,
      4.132828,
      0.023007,
      1.084111,
      0,
      4.630212,
      1,
      5.791440,
      0.656849,
      2,
      6.174387,
      4.536580,
      1.997307,
      3,
      NULL,
      6.827403,
      3,
      NULL,
      1,
      7.154666,
      6,
      1.089730,
      NULL,
      NULL,
      4.897107,
      1.224815,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.718972,
      NULL,
      2.853633,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.103428,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.326724,
      0,
      2.213834,
      5.373994,
      1,
      1,
      0.461652,
      NULL,
      NULL,
      NULL,
      1,
      0.787693,
      0.516294,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.406994,
      NULL,
      0,
      0.298391,
      0.405730,
      NULL,
      1,
      0.124606,
      1.990045,
      1,
      1.156669,
      0,
      0,
      0.365204,
      1,
      1,
      1.227133,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.358165,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.033011,
      '01333',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      0.028750,
      '',
      '',
      NULL,
      NULL,
      NULL,
      2.716134,
      4.645029,
      0.569381,
      0,
      3.263675,
      NULL,
      2.221247);
commit;
end;
/


