set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9673213';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-8-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0101',
      NULL,
      NULL,
      NULL,
      '0332412',
      44.943064,
      6,
      3.431148,
      1,
      '012231',
      NULL,
      '10-11-2002',
      35,
      NULL,
      NULL,
      NULL,
      1.380170,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.994622,
      2,
      1.263328,
      5,
      1,
      0,
      0.707884,
      11.081934,
      9.036099,
      8,
      NULL,
      2,
      1,
      1.023735,
      1.385342,
      5.207322,
      3,
      0,
      NULL,
      2.303716,
      NULL,
      NULL,
      NULL,
      1.567903,
      NULL,
      NULL,
      3.992797,
      0.408008,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.358831,
      1.306594,
      1,
      3.738215,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      6.936409,
      6,
      0.501230,
      2,
      4,
      2.569255,
      1.660039,
      5,
      0,
      NULL,
      4.752347,
      0,
      0.811271,
      NULL,
      1.457390,
      NULL,
      0,
      0.012719,
      NULL,
      NULL,
      NULL,
      4,
      3.335930,
      0,
      0.738402,
      NULL,
      1.196158,
      0,
      0.049952,
      3,
      2,
      4.816002,
      0,
      NULL,
      6,
      3,
      4.938546,
      3.798126,
      1,
      5,
      6,
      3,
      2.396686,
      6,
      3.951669,
      1.295604,
      6.725019,
      1,
      NULL,
      1.559945,
      0,
      3.716631,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      7.972095,
      0.348851,
      NULL,
      3.800200,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.385713,
      NULL,
      NULL,
      NULL,
      NULL,
      4.298378,
      1.911492,
      0,
      3,
      1,
      4.329259,
      3,
      0.904188,
      NULL,
      3.672338,
      0,
      2.610802,
      2,
      NULL,
      0.659656,
      2,
      1.861306,
      NULL,
      0.193877,
      NULL,
      NULL,
      NULL,
      1,
      4.735676,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      1,
      0.419715,
      3,
      0.724975,
      3.033858,
      1.512741,
      0,
      3.783534,
      0.537573,
      0,
      NULL,
      1.020049,
      1.021722,
      NULL,
      0.160095,
      1.298797,
      0.964736,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.252963,
      '01244',
      '',
      '',
      1,
      '',
      '',
      '',
      2.849807,
      NULL,
      '',
      NULL,
      4,
      NULL,
      3.322969,
      5.338702,
      0,
      0.822764,
      0,
      1.703093,
      NULL);
commit;
end;
/


