set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9021970';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-2-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '0',
      NULL,
      NULL,
      '1321142',
      1.382992,
      3,
      0.276349,
      3,
      '113034',
      3,
      ' 2-21-2002',
      5,
      NULL,
      1,
      NULL,
      0.083305,
      0.416041,
      0.156922,
      0,
      1,
      0,
      1.122537,
      0,
      1,
      1,
      1,
      1.349645,
      NULL,
      0.043208,
      0.134107,
      0.291035,
      0.700066,
      1.153446,
      0.247018,
      1,
      0,
      0.111943,
      0.525123,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.494984,
      1.293786,
      0,
      1,
      1.877085,
      0,
      0.594439,
      0.877166,
      1,
      1,
      0,
      0,
      0,
      0.029273,
      0.973598,
      NULL,
      0,
      1.214243,
      2.195642,
      1,
      2,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.368406,
      0,
      0.453250,
      0.042075,
      0.137475,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      1.532079,
      1.460137,
      1,
      NULL,
      NULL,
      NULL,
      1.694542,
      NULL,
      NULL,
      0,
      1,
      NULL,
      5,
      0,
      3.792227,
      0.533090,
      3,
      NULL,
      5,
      1,
      0.059285,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      4,
      6,
      3,
      NULL,
      6,
      NULL,
      1,
      NULL,
      1,
      0.562507,
      NULL,
      NULL,
      2.058514,
      0.939352,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.216660,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.173228,
      NULL,
      NULL,
      3.814892,
      1.665279,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      0.533515,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      5,
      NULL,
      0,
      0.480888,
      NULL,
      NULL,
      NULL,
      0,
      0.127455,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.608065,
      1,
      1.012397,
      NULL,
      0,
      1,
      0,
      1.649487,
      NULL,
      0.984315,
      0,
      0,
      NULL,
      1,
      1.334586,
      1.185166,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.549190,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.121526,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.103605,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.360924,
      3.536645,
      NULL,
      0,
      1.174713,
      1.650543,
      0,
      1,
      '32442',
      '44243',
      NULL,
      NULL,
      '',
      '',
      '',
      0.797870,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


