set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9021970';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-2-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '0',
      NULL,
      NULL,
      '2001432',
      7,
      1,
      2,
      0,
      '330024',
      0,
      NULL,
      42,
      NULL,
      NULL,
      NULL,
      5.916320,
      0.905724,
      3,
      1,
      0.300503,
      NULL,
      NULL,
      1,
      0,
      1.860896,
      1.504053,
      0,
      0,
      NULL,
      4,
      1,
      1,
      1.650537,
      4.996722,
      7.685945,
      0,
      0,
      1.332988,
      2,
      0,
      1.498827,
      0,
      1.432749,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      6.239320,
      2.040309,
      1.280510,
      0,
      0,
      0.359341,
      0,
      NULL,
      3.918266,
      1.650566,
      NULL,
      1,
      1.039490,
      NULL,
      2.102777,
      0.471382,
      0,
      NULL,
      1.475331,
      3,
      NULL,
      0,
      0,
      0.572846,
      0.749591,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.747939,
      0.086927,
      2.294248,
      0,
      3,
      1,
      3.374978,
      0,
      0.416605,
      4,
      NULL,
      0,
      NULL,
      NULL,
      1.068434,
      0.882738,
      0,
      0.856966,
      1,
      NULL,
      0.241934,
      0,
      0.037213,
      0,
      2,
      0,
      1.806799,
      1,
      0,
      1.366504,
      1.445736,
      NULL,
      2,
      0,
      2,
      1.502230,
      1.168737,
      0.519791,
      4.819222,
      0,
      4.385569,
      0,
      3,
      2.485366,
      NULL,
      NULL,
      1.400780,
      1.408836,
      1.071409,
      1,
      1.577801,
      7.768894,
      0.072352,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      2,
      1.834354,
      NULL,
      0.722768,
      0.694110,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.809375,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.328243,
      2,
      0,
      3.125702,
      1,
      0.763466,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.972687,
      0,
      0.652478,
      0.179507,
      NULL,
      1.732886,
      NULL,
      1,
      NULL,
      NULL,
      1.896015,
      0,
      NULL,
      1,
      NULL,
      1.020416,
      1.985213,
      1,
      NULL,
      0.960541,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.857093,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.648856,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.530236,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.283467,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.727757,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.778121,
      2,
      1.007648,
      1.797754,
      1.790425,
      1,
      1,
      1.116791,
      '12004',
      '24041',
      '',
      NULL,
      '',
      '',
      '',
      0.053067,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


