set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9021970';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-1-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      NULL,
      NULL,
      NULL,
      NULL,
      36.881417,
      1,
      0,
      NULL,
      '104111',
      0.648330,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.095971,
      3.263043,
      1.690315,
      NULL,
      0.462532,
      0.401053,
      0,
      NULL,
      1.988346,
      2,
      1.485511,
      0,
      4.334340,
      NULL,
      1.750799,
      2.700434,
      0,
      2,
      1,
      1.061583,
      1.605164,
      0.488459,
      0,
      NULL,
      1,
      0.000991,
      NULL,
      NULL,
      NULL,
      1.964252,
      NULL,
      NULL,
      1.261797,
      0.408663,
      0,
      3,
      NULL,
      0,
      0,
      3.235710,
      0,
      2.649861,
      0.583591,
      0.740936,
      0.656635,
      0.995098,
      0,
      0,
      NULL,
      0,
      0.093632,
      0,
      1,
      NULL,
      4,
      0,
      NULL,
      0.995713,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.493016,
      0,
      0,
      1,
      0,
      0.333087,
      1.285462,
      0,
      0,
      1.968914,
      1.851278,
      NULL,
      2.688735,
      0.468579,
      NULL,
      0.061496,
      0.068407,
      0,
      NULL,
      1.410194,
      1,
      0,
      1.442988,
      1.636601,
      0.822887,
      1.667379,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.196066,
      1,
      0.291626,
      0.116654,
      5,
      4.548822,
      5.983169,
      6,
      5.996832,
      1.869869,
      0.600668,
      0,
      0.127124,
      1.001068,
      0,
      1.440754,
      1.460993,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.530493,
      0,
      2,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.262629,
      NULL,
      NULL,
      NULL,
      NULL,
      0.609698,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.335292,
      0,
      2,
      1,
      1.342808,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.809523,
      1.990465,
      1.276812,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.724386,
      1,
      2,
      2.520765,
      1.353711,
      0,
      NULL,
      1.659859,
      1.279239,
      2.974272,
      0,
      0,
      1.534353,
      1,
      1.554032,
      0,
      1.913042,
      1,
      NULL,
      1.915329,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.831975,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.763557,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.765012,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.836581,
      NULL,
      NULL,
      NULL,
      NULL,
      1.547680,
      1.735803,
      NULL,
      NULL,
      0.901040,
      0.191592,
      1.035152,
      NULL,
      2.051395,
      '03230',
      '40231',
      '',
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


