set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9021970';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-7-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '132',
      '44',
      NULL,
      8,
      '1220310',
      116.913258,
      NULL,
      NULL,
      2,
      '213014',
      3,
      ' 5-13-1979',
      31.276356,
      NULL,
      NULL,
      NULL,
      1.677931,
      NULL,
      NULL,
      1,
      1.260898,
      0,
      1,
      NULL,
      1.290271,
      0,
      3.457095,
      1.316838,
      0,
      2,
      1,
      1,
      0,
      1,
      4.375199,
      NULL,
      0,
      0,
      4,
      0,
      0.430283,
      NULL,
      2,
      0.655519,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.394662,
      3,
      5.776697,
      0,
      1,
      1.941031,
      3.777442,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.529176,
      1,
      NULL,
      0,
      NULL,
      1.165897,
      NULL,
      NULL,
      0,
      0,
      5.728368,
      0,
      NULL,
      0.505408,
      1.071638,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.277234,
      NULL,
      1,
      NULL,
      1,
      1.405773,
      1,
      0.058773,
      1.251301,
      4,
      0,
      1.631671,
      1,
      5,
      0,
      0,
      1.725363,
      0.385703,
      1,
      NULL,
      1,
      0.330532,
      NULL,
      0,
      NULL,
      0.840697,
      0.755099,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.123041,
      2.255348,
      1,
      2,
      0,
      NULL,
      2,
      3.469458,
      1,
      7,
      NULL,
      7,
      0.967227,
      NULL,
      1,
      1.076188,
      NULL,
      NULL,
      0.190344,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.221211,
      0,
      NULL,
      0.561102,
      1.512841,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.664076,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.725621,
      NULL,
      1,
      1,
      1,
      0,
      5.068416,
      1,
      NULL,
      NULL,
      0,
      0.780913,
      0.620315,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.699878,
      0.927299,
      0,
      NULL,
      3,
      0.384350,
      0,
      NULL,
      0.271334,
      0,
      1.062848,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      1.403140,
      1.971850,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.987063,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.528110,
      1.241857,
      NULL,
      NULL,
      0,
      0,
      1,
      4.444117,
      '02344',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


