set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9021970';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-2-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '014',
      '44',
      29,
      14.841570,
      '4210244',
      140,
      0,
      NULL,
      1,
      '101341',
      2.122745,
      NULL,
      45,
      28,
      NULL,
      NULL,
      NULL,
      1.689920,
      1,
      1,
      0.987650,
      0,
      0,
      NULL,
      0.960462,
      0,
      8.519737,
      NULL,
      0.944097,
      NULL,
      0,
      0.093979,
      10,
      1.699628,
      3,
      8.937423,
      2.211821,
      1,
      9,
      0,
      NULL,
      1,
      NULL,
      1.618827,
      NULL,
      NULL,
      0.388065,
      NULL,
      NULL,
      2,
      4.524040,
      1.329306,
      3,
      1.070263,
      NULL,
      2,
      NULL,
      0.946318,
      0,
      1,
      1,
      1.599529,
      NULL,
      0.538823,
      1.201272,
      2,
      0.802448,
      NULL,
      4,
      2.407113,
      NULL,
      NULL,
      NULL,
      0,
      1.265950,
      0.349747,
      NULL,
      NULL,
      1.072867,
      NULL,
      NULL,
      1,
      1,
      0.369489,
      2,
      1,
      5.594328,
      4.998286,
      1,
      NULL,
      5.566924,
      1.162550,
      1.051676,
      1.081155,
      3,
      1,
      1.864371,
      0,
      1.250163,
      1.109908,
      NULL,
      0.347993,
      1,
      1,
      1.402556,
      NULL,
      0.066816,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.270288,
      0.170087,
      NULL,
      1,
      2,
      3.495664,
      6.574165,
      6.652842,
      6,
      9,
      5,
      0.063047,
      1,
      0.075389,
      0.599567,
      0.163985,
      0,
      3,
      1.648643,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1.403585,
      0.074019,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.643111,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.717480,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      0.487067,
      0.175644,
      NULL,
      NULL,
      1.839183,
      NULL,
      NULL,
      1.340407,
      3,
      1.196684,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.987754,
      NULL,
      NULL,
      NULL,
      0.006556,
      3,
      1.956715,
      1.705848,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      0.992995,
      1,
      0,
      0.290372,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.419040,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.626260,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.921520,
      0.544042,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      5.435915,
      NULL,
      '10234',
      '',
      NULL,
      '',
      '',
      '',
      0.875748,
      '',
      '',
      '',
      3.600355,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


