set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9021970';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-8-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '130',
      '43',
      NULL,
      20,
      '2024320',
      11,
      5,
      3.993537,
      2,
      '013113',
      5,
      '10- 7-2003',
      9.267606,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1,
      0.893021,
      1.179330,
      NULL,
      0,
      0,
      5.216435,
      0.667722,
      1,
      5.337190,
      NULL,
      0.423760,
      1.111333,
      0.964126,
      7.596345,
      0,
      NULL,
      NULL,
      1.696972,
      0,
      0,
      3,
      0,
      0,
      NULL,
      NULL,
      0.519415,
      NULL,
      NULL,
      7.470062,
      3.788733,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      2,
      NULL,
      3.264938,
      NULL,
      1.112021,
      0.627535,
      0,
      0,
      0.802932,
      NULL,
      1,
      1,
      1,
      4.378007,
      NULL,
      2,
      0.813864,
      1,
      NULL,
      NULL,
      1.998589,
      NULL,
      NULL,
      1,
      1,
      3.625311,
      1,
      3.323349,
      NULL,
      1.230891,
      0,
      1.667330,
      3.851370,
      NULL,
      NULL,
      0.973666,
      NULL,
      1.996422,
      0,
      1,
      1.835439,
      0,
      NULL,
      1,
      NULL,
      1,
      0.185328,
      0.340650,
      0.430627,
      1.230299,
      3.507648,
      NULL,
      NULL,
      NULL,
      NULL,
      0.955718,
      0,
      2,
      NULL,
      NULL,
      NULL,
      5.625789,
      3,
      3.568211,
      4,
      2.244920,
      4.690658,
      3,
      0,
      1.696142,
      0.791639,
      3.423781,
      1.503131,
      1,
      3.556202,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.312339,
      NULL,
      1,
      1,
      1.458420,
      0.171126,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.876518,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.149214,
      NULL,
      5,
      NULL,
      NULL,
      4,
      0,
      NULL,
      NULL,
      1.104672,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.438968,
      NULL,
      3.945637,
      0,
      1,
      1.382375,
      0,
      0.095070,
      NULL,
      NULL,
      1.303511,
      0,
      1,
      0.488250,
      1.191997,
      0.266373,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.139135,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.062194,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.242048,
      NULL,
      1.157175,
      NULL,
      NULL,
      1.188567,
      0,
      0,
      NULL,
      NULL,
      '41200',
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      NULL,
      NULL,
      0.332124,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


