set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9021970';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-2-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '433',
      '11',
      NULL,
      8.634254,
      NULL,
      28,
      0,
      2.869222,
      2,
      '223421',
      3.326270,
      '11-29-1977',
      12,
      44,
      1.507237,
      NULL,
      0.631738,
      1,
      1.615189,
      NULL,
      0.668089,
      0.732574,
      NULL,
      1.248193,
      1,
      NULL,
      3,
      1,
      0,
      8.760568,
      1,
      0.253864,
      4,
      3.808481,
      NULL,
      2,
      4,
      1.752589,
      9.761102,
      1,
      2,
      1.039666,
      NULL,
      1,
      NULL,
      NULL,
      1.667519,
      NULL,
      NULL,
      NULL,
      1.826008,
      3.067748,
      2.679767,
      0,
      1,
      0,
      NULL,
      2.299687,
      0.864383,
      0.075562,
      3,
      NULL,
      1,
      0,
      NULL,
      1.118942,
      1,
      1,
      0.151286,
      1.244811,
      0,
      0.179798,
      0,
      2,
      0.677216,
      0.755842,
      NULL,
      NULL,
      1.669254,
      NULL,
      NULL,
      NULL,
      4.384947,
      0,
      1,
      NULL,
      0.542554,
      4.542082,
      NULL,
      0.777022,
      6,
      0,
      0.768289,
      0.250264,
      NULL,
      0.803296,
      1,
      0,
      0,
      0.485259,
      NULL,
      1,
      1,
      0,
      0,
      1.976820,
      1,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      4.553953,
      NULL,
      2,
      1,
      NULL,
      5,
      2,
      6,
      0,
      NULL,
      4,
      0,
      0.144909,
      1.852067,
      1,
      1.343698,
      NULL,
      1.331405,
      0.280075,
      3,
      1.667013,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.672717,
      0,
      NULL,
      NULL,
      0,
      0.085842,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1.948763,
      NULL,
      NULL,
      1.097759,
      1,
      NULL,
      1.659114,
      7,
      5,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      1,
      5.847798,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      3.271465,
      NULL,
      2,
      3,
      NULL,
      3.803317,
      NULL,
      0,
      1,
      1.824556,
      0.302772,
      0.702154,
      NULL,
      1.160852,
      1.449569,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.364991,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.304933,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.641455,
      NULL,
      NULL,
      NULL,
      NULL,
      0.944608,
      NULL,
      NULL,
      NULL,
      NULL,
      2.698364,
      2,
      3.576721,
      3,
      NULL,
      0.861876,
      1.937477,
      1,
      4.799425,
      '01311',
      '01114',
      NULL,
      1.682709,
      '',
      NULL,
      '',
      1.178394,
      '',
      '',
      '',
      4.229803,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


