set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9021970';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-7-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '31',
      19.521082,
      12.673253,
      NULL,
      74,
      0,
      1,
      0,
      '321213',
      NULL,
      ' 0- 5-2002',
      16,
      NULL,
      1.013668,
      NULL,
      1.495966,
      0.927165,
      NULL,
      1,
      1,
      1.290303,
      1.682133,
      0.782912,
      1.724107,
      NULL,
      NULL,
      1.697007,
      1,
      7,
      7.208981,
      0.371670,
      4.854049,
      0.122009,
      1,
      NULL,
      2.703436,
      3,
      6.541721,
      NULL,
      5.953156,
      4.666722,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      3.985697,
      0,
      NULL,
      0,
      0,
      0.403823,
      1,
      0,
      0,
      0,
      0,
      0.374368,
      0.822574,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.056234,
      NULL,
      NULL,
      1.888096,
      NULL,
      2.561397,
      1,
      4.296807,
      NULL,
      2,
      1,
      NULL,
      0,
      0,
      1.628845,
      0,
      2.348807,
      NULL,
      0.700418,
      NULL,
      1,
      0,
      NULL,
      1.941998,
      0,
      1.781772,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      5.615045,
      6,
      NULL,
      NULL,
      7.677152,
      3,
      5,
      1.169069,
      2.010962,
      NULL,
      1,
      0.159057,
      2.505603,
      0.769600,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.968570,
      1.891082,
      1,
      NULL,
      0.648378,
      1,
      2.289599,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.683827,
      NULL,
      8,
      NULL,
      0.718778,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.901999,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.452997,
      NULL,
      5.145085,
      2,
      0,
      1.709511,
      NULL,
      NULL,
      0.702038,
      1,
      0.395235,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.537764,
      NULL,
      3.692850,
      1.741953,
      3.093519,
      0,
      0,
      NULL,
      2.980647,
      1,
      NULL,
      1.891394,
      0,
      1.956191,
      1.261973,
      1,
      0,
      1.616067,
      0.187851,
      0.348938,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.924433,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.905811,
      NULL,
      NULL,
      NULL,
      NULL,
      1.896392,
      3,
      2.966101,
      NULL,
      1,
      0.985816,
      0.885340,
      0,
      1,
      '21012',
      '21202',
      '',
      1.281789,
      '',
      NULL,
      NULL,
      1,
      NULL,
      '',
      NULL,
      3.946660,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


