set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9778338';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-7-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1020',
      '02022240',
      9,
      61,
      '4344441',
      4,
      2,
      2.270219,
      3,
      '204313',
      4,
      ' 4-28-1987',
      44.500877,
      16,
      1.597227,
      NULL,
      NULL,
      NULL,
      2.103752,
      NULL,
      0,
      0,
      0,
      2.015390,
      0,
      0.505353,
      1,
      1,
      0,
      1,
      1.567711,
      1,
      1,
      NULL,
      1.815213,
      0,
      1.173869,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.338027,
      1.736949,
      0.324292,
      NULL,
      1.407975,
      0,
      NULL,
      1,
      1,
      1.975513,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.266934,
      NULL,
      1,
      0.913126,
      0.053477,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.512500,
      0,
      1.896308,
      1,
      0,
      4.339345,
      0.477994,
      5.509439,
      0.525266,
      1.434241,
      1,
      2,
      0.680698,
      0.848499,
      1.048216,
      0,
      NULL,
      NULL,
      9,
      0.319915,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.188183,
      0,
      1,
      1.277051,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.188916,
      NULL,
      NULL,
      NULL,
      NULL,
      1.765079,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.825926,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.360890,
      NULL,
      0,
      2,
      0.715631,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.700641,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.528882,
      1.527361,
      1.911751,
      1.812204,
      1.027244,
      0.589617,
      NULL,
      1.750241,
      0,
      0,
      1.122981,
      NULL,
      1.533523,
      0,
      1.390267,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.131473,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.681250,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.940581,
      NULL,
      NULL,
      0,
      NULL,
      1.658268,
      0,
      NULL,
      '24430',
      '',
      '',
      1.886516,
      '',
      '',
      '',
      0.078450,
      '',
      '',
      NULL,
      4,
      6,
      0.909453,
      NULL,
      1.713005,
      NULL,
      3.353665,
      3.134961,
      3.333689);
commit;
end;
/


