set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9778338';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-1-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4442',
      '23012030',
      65.505046,
      NULL,
      '4422433',
      4,
      0,
      3.745034,
      0,
      '131243',
      3,
      ' 5-14-1984',
      32.463660,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      0.195257,
      NULL,
      1.068663,
      0,
      3.252990,
      0,
      0,
      1,
      1.673466,
      0,
      1.302158,
      0,
      1.024059,
      1,
      NULL,
      0.000883,
      1,
      NULL,
      0.792249,
      0.609942,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.009637,
      1.735232,
      NULL,
      1.538708,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.634917,
      0,
      1.256690,
      0.065312,
      0.197988,
      0,
      0,
      0.382728,
      0,
      NULL,
      0,
      1.010966,
      1.104219,
      0.328023,
      NULL,
      NULL,
      NULL,
      0.289433,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.393138,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.459244,
      0,
      0.257839,
      1,
      0,
      0.170175,
      NULL,
      5.793142,
      2.519963,
      1,
      0,
      1.870227,
      NULL,
      NULL,
      3.141653,
      NULL,
      NULL,
      NULL,
      5.660843,
      0.973103,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.521991,
      0.402021,
      2,
      0,
      0,
      0,
      0.387695,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.672657,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.115083,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.794312,
      1,
      4.674271,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0.667777,
      0,
      1.604706,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.196236,
      NULL,
      1,
      0,
      0,
      1.840529,
      0.036748,
      1,
      1.949970,
      3,
      NULL,
      1.546887,
      1.888858,
      NULL,
      0.771346,
      1.494246,
      0,
      NULL,
      0.529650,
      1.486878,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.324039,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.022016,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.708986,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.176980,
      0,
      NULL,
      0.368650,
      1,
      1.975007,
      0,
      0,
      '11043',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      0.553071,
      NULL,
      NULL,
      NULL,
      3.612022,
      3,
      3.889742,
      1,
      1.368046);
commit;
end;
/


