set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9778338';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-7-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1401',
      '21423121',
      NULL,
      6,
      '4243212',
      7,
      6,
      NULL,
      1,
      '424404',
      4,
      NULL,
      65.261265,
      52.431729,
      0.621881,
      NULL,
      4,
      1.797866,
      1.034325,
      0,
      1.769026,
      2.604087,
      0,
      0,
      1,
      0.164057,
      1.338053,
      0,
      0,
      0.142200,
      0.109737,
      NULL,
      1,
      NULL,
      1.124207,
      1,
      1.508940,
      0.733369,
      1.501719,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.808580,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.318297,
      1.788110,
      NULL,
      0.299373,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.836091,
      1.512520,
      0.623152,
      0.565280,
      0,
      1,
      1,
      NULL,
      1.927373,
      0,
      0,
      NULL,
      1.589917,
      NULL,
      0.728579,
      1,
      0.163549,
      0,
      NULL,
      1,
      NULL,
      1.071604,
      0.232291,
      1.611338,
      0.414482,
      NULL,
      1,
      1,
      0,
      NULL,
      0.330863,
      1,
      1.034979,
      0,
      1,
      1,
      NULL,
      1,
      3.893861,
      NULL,
      1,
      0,
      1,
      4.341942,
      0.241155,
      NULL,
      0.702442,
      0,
      NULL,
      NULL,
      7,
      0.787416,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0.995408,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.567743,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.605650,
      1,
      0.477387,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.604230,
      0.283680,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1.504293,
      0.922349,
      1,
      1,
      1.516224,
      0.245526,
      NULL,
      0.280817,
      0.502442,
      1.248202,
      NULL,
      0,
      0.286558,
      0.599660,
      1.061146,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.361620,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.482172,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.555554,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      '32311',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.564552,
      '',
      NULL,
      NULL,
      4,
      1,
      1,
      3,
      3,
      1.856092,
      NULL,
      3,
      2);
commit;
end;
/


