set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7620831';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-4-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '4',
      NULL,
      NULL,
      '1044433',
      17.714403,
      5,
      0.593201,
      2,
      '124344',
      2.179300,
      ' 5-18-1990',
      NULL,
      NULL,
      1.336375,
      NULL,
      1,
      0,
      0.952064,
      1,
      1,
      0,
      NULL,
      3.270117,
      1,
      0.180323,
      3.351178,
      0.610908,
      NULL,
      1,
      0.473157,
      1.929270,
      NULL,
      0,
      0,
      1.405756,
      0.548476,
      0,
      NULL,
      1,
      2,
      1,
      0,
      0.062254,
      NULL,
      NULL,
      1.931214,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.720435,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.348381,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.466219,
      0,
      1,
      1.979061,
      1.925943,
      1,
      0.632629,
      NULL,
      NULL,
      0.354808,
      0.847615,
      NULL,
      1.841734,
      0.779983,
      1.139490,
      0,
      1,
      NULL,
      NULL,
      0.691650,
      1.009856,
      0.231397,
      0,
      NULL,
      0.587993,
      0.240950,
      NULL,
      NULL,
      NULL,
      NULL,
      1.398718,
      NULL,
      1,
      0.904365,
      NULL,
      3.083384,
      6,
      3.490727,
      8,
      5.954432,
      2,
      8,
      7.218459,
      1,
      3.047126,
      5.822243,
      0,
      NULL,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.677158,
      NULL,
      2,
      0,
      0.968108,
      0.676174,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.055791,
      NULL,
      NULL,
      NULL,
      NULL,
      1.102450,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.704555,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.843496,
      0,
      0.765697,
      4,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.892919,
      0.447960,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      0.139330,
      3.315696,
      1.051975,
      NULL,
      NULL,
      0,
      0.842914,
      0.924845,
      1,
      1,
      0.170263,
      1.791015,
      1.252970,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.149290,
      '21121',
      '',
      NULL,
      1.846388,
      '',
      '',
      NULL,
      1.977528,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


