set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7620831';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-10-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '34143304',
      45,
      NULL,
      NULL,
      136,
      2,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2.240487,
      1.050532,
      NULL,
      0,
      1,
      0,
      0.627529,
      0.566798,
      0,
      2.045880,
      1,
      1,
      0,
      5.644715,
      0.483219,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.553266,
      0.522629,
      0.046643,
      3,
      1,
      1.008733,
      NULL,
      1.523118,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.114638,
      0,
      0,
      0.675702,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.649476,
      1,
      1,
      1.806314,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.308584,
      3,
      4.725880,
      0,
      4.633477,
      4.733988,
      4,
      0,
      0,
      NULL,
      3.294465,
      NULL,
      0,
      1,
      1,
      1.924727,
      1.082070,
      NULL,
      1,
      NULL,
      1.810840,
      1.703583,
      2.762998,
      NULL,
      1.416415,
      0.242234,
      3,
      1.918370,
      1,
      1.965741,
      0.574615,
      0,
      1.982032,
      0.326133,
      0,
      NULL,
      4.707838,
      NULL,
      1,
      2,
      2,
      6.608215,
      2.049948,
      NULL,
      6,
      NULL,
      3.604931,
      4,
      2,
      0.088117,
      1,
      3,
      4.739987,
      NULL,
      5.291311,
      1.920934,
      1,
      0.508170,
      1,
      1,
      1,
      0,
      0.819244,
      1.170795,
      2.767397,
      0.098648,
      1,
      0.860303,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.377226,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.333815,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.799922,
      NULL,
      0.262568,
      NULL,
      NULL,
      1.268958,
      NULL,
      NULL,
      NULL,
      1.053273,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.566337,
      0.214635,
      1,
      0.295752,
      3,
      1,
      3.535867,
      NULL,
      1,
      1,
      0.218227,
      NULL,
      1,
      1,
      1.902193,
      0.644892,
      0.322807,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.978303,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.551657,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.793155,
      1.338385,
      1.755308,
      2,
      3.503305,
      '14043',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      2,
      1,
      NULL,
      1,
      7,
      0,
      NULL,
      NULL,
      1);
commit;
end;
/


