set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7620831';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-4-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '401',
      '40404200',
      41.659887,
      42.317654,
      NULL,
      7,
      NULL,
      NULL,
      3,
      NULL,
      3.678738,
      ' 7-16-2001',
      38,
      16,
      0.309277,
      NULL,
      NULL,
      0.057779,
      2,
      1.503108,
      1.010527,
      1.107260,
      1.980460,
      NULL,
      0.919530,
      1,
      1,
      1,
      1.005823,
      0.172816,
      3,
      1.465167,
      NULL,
      NULL,
      1.796525,
      0,
      0,
      0.240060,
      3.972718,
      1,
      3,
      3.150589,
      NULL,
      0.565991,
      NULL,
      NULL,
      0.660444,
      NULL,
      NULL,
      0,
      0.429899,
      1,
      0.671286,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.034422,
      1,
      1.259132,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.265320,
      0,
      0,
      1,
      4,
      5.322200,
      5,
      0.360928,
      0,
      2,
      4,
      0.457888,
      0.899169,
      6,
      0,
      1,
      0.411259,
      1.463929,
      1.022033,
      NULL,
      NULL,
      NULL,
      2,
      0.416871,
      1.330573,
      4,
      4.869388,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.413947,
      1.927958,
      0,
      0.447336,
      7,
      NULL,
      NULL,
      2.683685,
      7,
      NULL,
      0.590807,
      7.551304,
      0,
      0,
      4.177071,
      3.254838,
      0.808321,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      7.260146,
      1,
      NULL,
      1,
      1,
      1.470045,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.874947,
      NULL,
      4,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.336730,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.842279,
      4,
      0.647860,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.052900,
      0.243233,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.519100,
      2,
      NULL,
      1,
      NULL,
      3,
      0,
      0,
      1,
      3.027291,
      1.722310,
      0.702055,
      1.885435,
      1.746421,
      1,
      1,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.322241,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.468476,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.437965,
      NULL,
      NULL,
      NULL,
      0,
      0.975502,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.168754,
      1,
      NULL,
      1.491600,
      0.128392,
      0.618801,
      2,
      2,
      NULL,
      '',
      '',
      1,
      '',
      NULL,
      '',
      0.804684,
      '',
      '',
      NULL,
      5.066464,
      0.809475,
      2.495313,
      3.010072,
      3,
      3.319521,
      3.556343,
      NULL,
      3);
commit;
end;
/


