set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7620831';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-9-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '13404334',
      13,
      34,
      '0044400',
      171.558022,
      1,
      1,
      NULL,
      '121302',
      3,
      ' 2-17-1995',
      NULL,
      NULL,
      1.612427,
      NULL,
      NULL,
      3.308141,
      0.281750,
      1,
      0.385732,
      0.379731,
      3,
      0.098020,
      0.367163,
      1,
      1,
      1.378435,
      0,
      3,
      3,
      1,
      3,
      0.464174,
      0,
      0.970795,
      1.841611,
      1.766039,
      7.889050,
      0,
      3,
      1,
      NULL,
      3.328795,
      1.164257,
      0,
      1,
      NULL,
      NULL,
      0.868975,
      1.168507,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.120840,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.948429,
      5.063013,
      NULL,
      NULL,
      3.385563,
      6,
      1,
      1,
      7,
      8,
      0,
      0.649857,
      1.491714,
      1,
      NULL,
      NULL,
      1.160477,
      NULL,
      NULL,
      0.685895,
      1,
      NULL,
      1.793736,
      0.777844,
      3.209779,
      NULL,
      NULL,
      0.072149,
      1,
      NULL,
      0.001129,
      NULL,
      1.638652,
      NULL,
      2,
      3,
      5,
      4,
      NULL,
      2,
      8.736691,
      2.118488,
      8,
      9,
      NULL,
      1,
      5,
      3,
      0,
      0.994584,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.602897,
      NULL,
      NULL,
      1,
      1,
      0,
      2,
      NULL,
      1.092255,
      2.661978,
      0,
      0,
      0.145350,
      1.933558,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.857540,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.334824,
      3,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.169087,
      2.188527,
      1.812584,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.910202,
      0.493465,
      1.458213,
      1,
      3.620096,
      1,
      0,
      2,
      0,
      2,
      NULL,
      1,
      1,
      NULL,
      0.716204,
      0.224034,
      1,
      0.596729,
      0.558525,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.172278,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.541231,
      1.679494,
      1.214827,
      NULL,
      1,
      0.039080,
      0,
      2,
      NULL,
      '22331',
      '',
      '',
      0.987325,
      '',
      '',
      NULL,
      0,
      '',
      NULL,
      '',
      1,
      5,
      2.423338,
      NULL,
      NULL,
      3,
      1.020469,
      5.330500,
      0);
commit;
end;
/


