set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7620831';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-4-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '001',
      '14042233',
      NULL,
      38,
      '1014303',
      34.457995,
      3,
      2.705168,
      3,
      '431104',
      0.869639,
      ' 5-20-1996',
      NULL,
      72.373286,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      0.367434,
      3,
      3.624535,
      1,
      0.229920,
      NULL,
      0,
      1.429322,
      5,
      6.087612,
      1.317626,
      NULL,
      0,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.078406,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.520851,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.467487,
      1,
      0,
      0.624866,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.411255,
      4.927711,
      NULL,
      NULL,
      NULL,
      0,
      1.954280,
      1,
      3.322075,
      9,
      2,
      1,
      NULL,
      7,
      1.347384,
      NULL,
      1,
      0,
      0.915018,
      NULL,
      0,
      1,
      NULL,
      6.116286,
      0,
      1.146038,
      6.152010,
      1.243945,
      NULL,
      NULL,
      NULL,
      1.767556,
      NULL,
      NULL,
      1,
      2,
      4.777400,
      NULL,
      2.967946,
      1,
      2.517577,
      6.500592,
      11.344900,
      0,
      1.403643,
      0.104908,
      NULL,
      2.021940,
      3.754254,
      0,
      0,
      0,
      5.374265,
      NULL,
      4,
      1,
      1,
      0.973761,
      0.938375,
      NULL,
      2,
      2,
      1.979538,
      0.587064,
      0,
      NULL,
      0.922439,
      1.186064,
      0.912093,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0.447583,
      6.674905,
      1.677466,
      1.921851,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      1,
      NULL,
      1,
      0.505336,
      0.117034,
      2,
      NULL,
      2,
      1,
      NULL,
      1.992238,
      0,
      0,
      0,
      1,
      1.189199,
      1.212701,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      '43332',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.745559,
      '',
      NULL,
      '',
      1.013679,
      2.770529,
      0,
      2.323067,
      8.948420,
      NULL,
      0.967457,
      NULL,
      3);
commit;
end;
/


