set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8816454';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-12-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '1',
      NULL,
      NULL,
      '3424442',
      5,
      0,
      0,
      0,
      '200413',
      0,
      ' 2-24-1997',
      15.265129,
      NULL,
      0.402369,
      NULL,
      4.359186,
      1.367875,
      0,
      0.488181,
      0.493173,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.172336,
      0.996197,
      1,
      0.495483,
      NULL,
      0,
      0.937815,
      1.004953,
      2,
      NULL,
      1.111809,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.491162,
      0,
      0,
      1.742778,
      NULL,
      1,
      0.443948,
      1.412503,
      0,
      0.472804,
      1,
      0,
      NULL,
      0.990475,
      0.465018,
      0.652320,
      1,
      0,
      2.605920,
      0,
      3.918827,
      3.602386,
      2,
      1,
      NULL,
      2,
      1.502264,
      NULL,
      NULL,
      0.487385,
      NULL,
      NULL,
      1.324459,
      1.790127,
      3,
      1,
      NULL,
      1,
      2.360747,
      1,
      1,
      4.262227,
      0.048620,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      0.661400,
      1.905412,
      NULL,
      0,
      0,
      4.724372,
      1,
      1.846610,
      NULL,
      4,
      1,
      NULL,
      0,
      NULL,
      1,
      0.243818,
      0.784573,
      1.933224,
      1,
      0.956117,
      0,
      NULL,
      3.920603,
      2.811675,
      6,
      4,
      3,
      3.619198,
      5,
      1,
      NULL,
      0,
      NULL,
      NULL,
      2.129971,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      6,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4,
      NULL,
      2.132575,
      NULL,
      7,
      1,
      0,
      2.611316,
      1.322387,
      NULL,
      7.659586,
      0,
      1,
      1.125514,
      1,
      3.302197,
      4.684167,
      1.625245,
      NULL,
      5.343734,
      0.631482,
      1,
      0.660033,
      NULL,
      NULL,
      NULL,
      0.676977,
      4,
      1.700377,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.980746,
      NULL,
      0,
      1.197986,
      1,
      0,
      1,
      2,
      1,
      NULL,
      1,
      1.360310,
      0.250651,
      1,
      NULL,
      0.966328,
      0.063568,
      1.693089,
      1.103530,
      1.899233,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.118967,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '33210',
      '30124',
      '',
      0,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


