set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8816454';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-12-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '2',
      NULL,
      NULL,
      '0432310',
      11,
      NULL,
      1,
      2,
      NULL,
      2.189355,
      ' 2-15-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      0.864233,
      NULL,
      1,
      0,
      0,
      NULL,
      0.179912,
      1.711181,
      0.214190,
      0.690950,
      0.257927,
      1,
      1,
      1,
      0.941409,
      1,
      1,
      0,
      1.257944,
      0,
      0.078436,
      1.424972,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.472699,
      1.749940,
      NULL,
      3,
      0,
      1,
      2.210670,
      NULL,
      1,
      1,
      1.092878,
      3.470898,
      0.322704,
      0,
      0.331522,
      0,
      NULL,
      NULL,
      0,
      1.814466,
      3,
      3,
      1,
      2,
      0,
      1.208363,
      0.575911,
      NULL,
      NULL,
      0.870671,
      NULL,
      NULL,
      1.490929,
      1,
      0.938050,
      0.282257,
      2.668225,
      1.512973,
      2.413600,
      1,
      1.993510,
      3.471215,
      0.942707,
      1,
      1.582378,
      1,
      1.173697,
      0.207385,
      0,
      0,
      NULL,
      NULL,
      0.606667,
      1,
      5.903159,
      1,
      0,
      0.748176,
      3.249059,
      0,
      NULL,
      0.424277,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      2.158775,
      0,
      1,
      NULL,
      2.183985,
      1.183086,
      NULL,
      2,
      1.465183,
      0,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.451116,
      1,
      0,
      10,
      0,
      0.455745,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.567213,
      NULL,
      3,
      1,
      3,
      0.919880,
      1.946577,
      0,
      1.509773,
      5,
      NULL,
      1.914109,
      2,
      2,
      0,
      3.608328,
      0.832352,
      0.488951,
      1,
      1,
      4.580197,
      1,
      0.990607,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.836495,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.370766,
      3,
      NULL,
      1,
      NULL,
      1.552933,
      NULL,
      1,
      0,
      1,
      0,
      0,
      1.742134,
      0.775073,
      0.082688,
      1,
      1.593527,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.328951,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      '01221',
      '42122',
      '',
      NULL,
      '',
      '',
      '',
      1.366719,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


