set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8816454';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-6-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '0',
      NULL,
      NULL,
      '1041113',
      NULL,
      0,
      3.287728,
      NULL,
      NULL,
      0.666307,
      '10- 5-1999',
      0,
      NULL,
      0,
      NULL,
      10.578381,
      3.545420,
      0,
      1.474726,
      1,
      NULL,
      0.864519,
      NULL,
      0.230609,
      NULL,
      1,
      0,
      1.407236,
      0.774004,
      NULL,
      1.673055,
      0,
      0.133490,
      0.782817,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.383377,
      1.000527,
      0,
      3,
      NULL,
      0,
      NULL,
      3,
      1,
      2.003343,
      NULL,
      2,
      NULL,
      NULL,
      2,
      1.743813,
      NULL,
      NULL,
      1.679900,
      1,
      1.678190,
      1.037202,
      1.173910,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.846909,
      2,
      3,
      4.987391,
      NULL,
      2.057345,
      NULL,
      0,
      3.025938,
      NULL,
      1.302364,
      NULL,
      2,
      0.550859,
      NULL,
      0.776335,
      1.054958,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      1.224426,
      1.998629,
      NULL,
      1.058778,
      NULL,
      0,
      2,
      NULL,
      1.799334,
      1,
      NULL,
      1,
      0,
      0.547186,
      1.573280,
      2.895781,
      0.428507,
      0,
      3,
      5.181457,
      0.071170,
      NULL,
      0,
      0,
      NULL,
      NULL,
      8,
      1.161723,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.722812,
      2.055713,
      2,
      1,
      0.617557,
      0.505080,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.250723,
      NULL,
      NULL,
      NULL,
      NULL,
      5.108784,
      0.548103,
      0,
      0.955249,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.955729,
      5.635930,
      1.171620,
      0,
      2,
      0.470732,
      NULL,
      NULL,
      NULL,
      0.607428,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.579462,
      1,
      0.833534,
      NULL,
      NULL,
      0,
      0.003924,
      0.270832,
      0.231024,
      0,
      1.713324,
      1.129929,
      0.532190,
      1,
      NULL,
      NULL,
      0.676257,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.330721,
      1.081571,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.731808,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      0.594014,
      1,
      0.746651,
      1.504126,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.936712,
      1.774778,
      NULL,
      0,
      0.682965,
      0,
      0,
      4,
      '44413',
      NULL,
      '',
      0.382420,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


