set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8816454';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-3-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '4',
      NULL,
      NULL,
      '2001412',
      26,
      3,
      1,
      NULL,
      '333233',
      1,
      ' 3-19-1981',
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      1.163152,
      1.393591,
      1,
      1,
      0.593440,
      0,
      0.013691,
      0.068998,
      1.123661,
      0,
      NULL,
      0.974713,
      0,
      1.012033,
      1,
      0,
      1.846990,
      1,
      0,
      1.980755,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.630506,
      NULL,
      1.065067,
      2,
      1.383587,
      NULL,
      2,
      0,
      0.035777,
      0,
      3.565428,
      NULL,
      0.945836,
      2.727787,
      3.599298,
      0.451362,
      1,
      4,
      1,
      3,
      1,
      2,
      0.431942,
      1.372665,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.391650,
      3,
      2.866571,
      0.067302,
      4,
      3,
      0,
      0,
      1.873287,
      NULL,
      0,
      0,
      1,
      3,
      0,
      0.949765,
      0.863181,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.990522,
      0,
      0,
      0.559294,
      1.450334,
      1,
      NULL,
      0.564002,
      1.135256,
      1,
      1,
      1.027231,
      0,
      0.099220,
      0.199299,
      0,
      3,
      0.840515,
      1.191399,
      NULL,
      5.124883,
      3,
      NULL,
      NULL,
      1,
      0.955663,
      3.419227,
      NULL,
      0,
      NULL,
      2.992020,
      NULL,
      5,
      0,
      1,
      1,
      NULL,
      1.230746,
      1,
      NULL,
      3.964964,
      0,
      4,
      3,
      1,
      5.468489,
      1.575863,
      NULL,
      NULL,
      1.377570,
      NULL,
      NULL,
      NULL,
      NULL,
      8.159332,
      NULL,
      0.563960,
      2.550443,
      3.093676,
      10,
      10,
      1,
      NULL,
      3,
      3.427178,
      2.573964,
      7,
      NULL,
      0.251546,
      1,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.678714,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.597226,
      0.642513,
      0.377132,
      NULL,
      0,
      1,
      0,
      0,
      2,
      0.725107,
      0.624734,
      1,
      1.207240,
      NULL,
      0.446536,
      1,
      0,
      0.907030,
      0,
      0.793489,
      1,
      0,
      1,
      NULL,
      2,
      3,
      0,
      0.328271,
      0,
      1.464743,
      NULL,
      0.474170,
      1.225132,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.887329,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.085890,
      '03304',
      '11110',
      '',
      NULL,
      '13301',
      '',
      NULL,
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


