set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8816454';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-6-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '1',
      NULL,
      NULL,
      NULL,
      35,
      1,
      3.835004,
      0,
      '214304',
      0.307458,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      18,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.509120,
      1,
      3,
      0,
      NULL,
      1.033543,
      1,
      1.775746,
      0,
      1.249807,
      4.388076,
      1,
      1.568960,
      0,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.948839,
      3,
      1.929253,
      0.846790,
      0.368771,
      1,
      0.299042,
      1,
      NULL,
      1,
      2.448971,
      0.316459,
      NULL,
      3.244045,
      1,
      1,
      1.317187,
      NULL,
      0.116467,
      0,
      4.244809,
      NULL,
      3,
      1,
      1,
      0.777406,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      2,
      NULL,
      1,
      1,
      2,
      0.834277,
      1.719556,
      0,
      5,
      1,
      NULL,
      1.438834,
      NULL,
      0,
      NULL,
      1,
      1,
      0.971415,
      1.949396,
      NULL,
      1,
      3,
      0.631687,
      0,
      0,
      NULL,
      5,
      0.684170,
      1,
      5,
      0,
      0,
      NULL,
      0.468808,
      1,
      4,
      1.991205,
      0.414700,
      5,
      4,
      NULL,
      1,
      0,
      NULL,
      3.508822,
      0,
      3,
      2.524075,
      NULL,
      NULL,
      1,
      NULL,
      3,
      0.193524,
      2,
      2,
      2,
      3.122497,
      3,
      3.446043,
      2.704932,
      0,
      3,
      1.583433,
      NULL,
      NULL,
      5,
      5.319915,
      NULL,
      1,
      3,
      NULL,
      0.385211,
      1,
      1,
      1.843105,
      1,
      NULL,
      0,
      3,
      2,
      NULL,
      1.677390,
      2,
      4.385868,
      0,
      0,
      NULL,
      1,
      1.789554,
      NULL,
      NULL,
      NULL,
      0,
      1.190041,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      1,
      1.017828,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0.958630,
      1,
      1.906635,
      NULL,
      1,
      NULL,
      1.212009,
      1.801130,
      3.191447,
      1.075433,
      0,
      0,
      1,
      0.831479,
      1.208851,
      0,
      1,
      1.476563,
      0.154169,
      1.752438,
      1,
      1.822205,
      0.585688,
      1,
      1.650217,
      1.857709,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.265369,
      '43011',
      '01030',
      '',
      3.963104,
      '40044',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


