set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8816454';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-7-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '1',
      NULL,
      NULL,
      '0332211',
      NULL,
      0,
      0,
      2,
      '001033',
      2,
      '11-28-1988',
      5,
      NULL,
      0.558904,
      NULL,
      0.489338,
      1.268989,
      NULL,
      0.120018,
      NULL,
      1,
      1,
      0.980610,
      NULL,
      0,
      1,
      1.036857,
      0,
      1.307669,
      0.191769,
      0,
      1.278484,
      1,
      NULL,
      0,
      0,
      NULL,
      0.708352,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.788574,
      0,
      2.797786,
      0,
      1.956644,
      NULL,
      1,
      NULL,
      1.903010,
      2.729221,
      1.895101,
      NULL,
      NULL,
      0.148842,
      NULL,
      0.660275,
      NULL,
      0.989147,
      0,
      2.970804,
      1,
      1,
      3.168570,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.630887,
      NULL,
      NULL,
      NULL,
      3,
      7,
      1.885968,
      4,
      NULL,
      4,
      1,
      1,
      1,
      1,
      0,
      1.366520,
      NULL,
      0.496655,
      1.007819,
      0.113145,
      0.759370,
      0.753409,
      NULL,
      1.803813,
      0.940461,
      NULL,
      1.733065,
      NULL,
      0,
      1,
      1.152230,
      1.053351,
      NULL,
      0.826773,
      4,
      NULL,
      1.507530,
      3,
      NULL,
      NULL,
      0,
      3.676880,
      3,
      1.721463,
      3,
      4,
      NULL,
      2.857776,
      0.713618,
      0.551699,
      1.389548,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      4,
      1.111556,
      2.321114,
      NULL,
      5.241106,
      1,
      NULL,
      NULL,
      7,
      NULL,
      3.658100,
      1.001523,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.644078,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.797825,
      1.490523,
      NULL,
      1,
      2,
      0.793763,
      1,
      1.530671,
      1.787037,
      0,
      1.440778,
      NULL,
      NULL,
      NULL,
      1.181013,
      3.749932,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.441466,
      0,
      0.551712,
      1,
      3.184821,
      1,
      1.631238,
      NULL,
      1.389316,
      NULL,
      0.884180,
      1,
      0,
      NULL,
      0.226033,
      0.611180,
      0.759271,
      0.871333,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.644841,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      '03342',
      '',
      '',
      NULL,
      '01114',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


