set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8816454';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-12-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '0',
      NULL,
      NULL,
      '3313332',
      52.282452,
      4,
      2,
      NULL,
      '210302',
      0.468214,
      ' 5-14-1994',
      18.184163,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.521095,
      1,
      1,
      3,
      0,
      1.487305,
      0.464917,
      0,
      1,
      NULL,
      1,
      0.448583,
      0,
      0.479300,
      2.371849,
      NULL,
      NULL,
      NULL,
      NULL,
      0.828176,
      1.402495,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.089093,
      0.327511,
      1.456722,
      1,
      2.710231,
      2.275164,
      1.626013,
      2.467398,
      NULL,
      NULL,
      2,
      0.374126,
      1,
      0.137029,
      1,
      0,
      3,
      2,
      4.653669,
      NULL,
      3.074081,
      3,
      2,
      2,
      0,
      NULL,
      NULL,
      1,
      1,
      2.110759,
      1,
      1.878067,
      2.953864,
      0,
      5.153251,
      1,
      1.873162,
      0.364938,
      NULL,
      0,
      0.151868,
      1.388240,
      1.717410,
      NULL,
      0.099523,
      0,
      1.430485,
      1,
      0,
      NULL,
      0.543064,
      NULL,
      1.092970,
      0.402642,
      0,
      0.658700,
      0.038231,
      1,
      2.754788,
      2,
      1,
      0.320989,
      0.632461,
      1.135034,
      3.024072,
      0,
      2,
      1.332263,
      6.559593,
      3,
      5,
      6,
      3.564923,
      NULL,
      NULL,
      0.207007,
      0,
      1,
      0,
      0.350285,
      1.017121,
      1,
      0.017741,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.212177,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      7.248457,
      3.955562,
      NULL,
      NULL,
      0,
      NULL,
      0.946587,
      NULL,
      NULL,
      4.818271,
      1.480778,
      NULL,
      NULL,
      NULL,
      NULL,
      1.990761,
      NULL,
      3,
      3,
      3.790018,
      0,
      4,
      2,
      0,
      NULL,
      1,
      13.549413,
      1,
      3.812508,
      NULL,
      1,
      2.472893,
      NULL,
      0.101680,
      1,
      0,
      1.435256,
      1,
      1,
      NULL,
      0.049321,
      0.019070,
      1.952442,
      1,
      1,
      1.557028,
      0,
      NULL,
      1,
      1.055527,
      0.073848,
      1,
      1.362821,
      1.188142,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.554677,
      '44430',
      '43021',
      '',
      0,
      NULL,
      '',
      NULL,
      1.005783,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


