set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8816454';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-12-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      0,
      '030043',
      0.357051,
      ' 5- 9-2002',
      45.027889,
      NULL,
      1.660767,
      NULL,
      0.515296,
      NULL,
      NULL,
      0,
      1.853540,
      3,
      1,
      0,
      2.340006,
      NULL,
      NULL,
      NULL,
      NULL,
      2.314095,
      1,
      0,
      2,
      0,
      1.851914,
      1.872541,
      1,
      1.529433,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.439171,
      0,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      1,
      1,
      3,
      1,
      NULL,
      1,
      2,
      0,
      2,
      1,
      3,
      5,
      0,
      3.211268,
      7.957412,
      0,
      0,
      2,
      1.966151,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      4.996683,
      1,
      NULL,
      7,
      NULL,
      1,
      1.401534,
      5,
      4.375599,
      3,
      1,
      3.332605,
      1.164966,
      0.210357,
      0,
      1.848790,
      1,
      NULL,
      1,
      0.154569,
      1.869657,
      0.025081,
      0,
      0.977872,
      0,
      1,
      NULL,
      5.353497,
      NULL,
      0,
      2,
      0.752141,
      1,
      1.960460,
      0.740260,
      3,
      3.793434,
      4,
      4,
      3,
      7.973419,
      2.257433,
      1,
      1,
      1,
      1.780957,
      1.799578,
      NULL,
      1,
      NULL,
      2,
      NULL,
      5.767463,
      NULL,
      3,
      0.640688,
      NULL,
      1.835219,
      1,
      0,
      7.878788,
      4,
      NULL,
      1,
      0.564025,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.433386,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0.762333,
      0.366732,
      2.594197,
      0.637324,
      1,
      NULL,
      1,
      0.004569,
      1.639889,
      4.986692,
      0,
      0.189359,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.682344,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.339161,
      NULL,
      NULL,
      1.011953,
      0,
      3,
      0.733406,
      2,
      1,
      NULL,
      1,
      1.278296,
      0,
      0.639621,
      0.368763,
      0,
      NULL,
      1.291214,
      0,
      1.778642,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '31432',
      '',
      '',
      1,
      NULL,
      '',
      NULL,
      0.729692,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


