set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8816454';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-7-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '2',
      NULL,
      NULL,
      '1014030',
      NULL,
      6,
      0.764637,
      3,
      '032124',
      2,
      ' 6- 9-2002',
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      0.205570,
      1.230668,
      0,
      NULL,
      NULL,
      2.754014,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.182029,
      1,
      0,
      1,
      0,
      0.839691,
      1.199336,
      0.754187,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.634228,
      0,
      2.160826,
      NULL,
      NULL,
      1,
      2.628643,
      2.913531,
      0.433065,
      2.802700,
      0.152691,
      0.386576,
      2.319436,
      1,
      2,
      1,
      0,
      NULL,
      2.310870,
      1.632979,
      2.637491,
      2.485831,
      NULL,
      0,
      2,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.422662,
      1.452975,
      NULL,
      0.281171,
      NULL,
      2.596763,
      2.807205,
      NULL,
      0,
      0.258164,
      0,
      0.107686,
      1,
      NULL,
      NULL,
      0.875172,
      1.660690,
      0,
      1,
      NULL,
      NULL,
      1.289513,
      NULL,
      NULL,
      1,
      0.518405,
      0.081536,
      3.744097,
      NULL,
      NULL,
      NULL,
      NULL,
      1.995709,
      1.069032,
      NULL,
      1,
      0.648098,
      1.575534,
      NULL,
      2.929559,
      2,
      0.428681,
      7.674913,
      6,
      NULL,
      0,
      0.566448,
      0,
      3.267489,
      0,
      1.094617,
      8.997639,
      0.584906,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      1,
      NULL,
      1,
      1,
      1.188339,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      7.309388,
      NULL,
      1.199655,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.618920,
      1.222813,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.560587,
      NULL,
      1.270384,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0.276800,
      NULL,
      0.656628,
      0,
      0,
      1,
      1.496451,
      0.003212,
      1,
      NULL,
      1.840649,
      0,
      1.107924,
      1.418730,
      NULL,
      1.992115,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.011529,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.787407,
      NULL,
      NULL,
      NULL,
      NULL,
      0.343133,
      NULL,
      NULL,
      NULL,
      NULL,
      0.569340,
      NULL,
      0.977306,
      NULL,
      1,
      0.433075,
      1.085132,
      0,
      2.077088,
      '22030',
      '',
      '',
      1,
      '44144',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


