set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8816454';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-1-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '3',
      NULL,
      NULL,
      NULL,
      42,
      0,
      0,
      NULL,
      '322302',
      2,
      ' 9-19-1997',
      28,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1.122263,
      NULL,
      1,
      1.450358,
      0.309554,
      0,
      NULL,
      1.542308,
      1.751689,
      0,
      1.008497,
      1.706460,
      0,
      0.379266,
      NULL,
      0.807200,
      0.575184,
      1,
      0.014066,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      0,
      1,
      0.996011,
      NULL,
      NULL,
      NULL,
      2.385395,
      1,
      3.226267,
      NULL,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0.695206,
      3.155408,
      NULL,
      4,
      NULL,
      6,
      0,
      1,
      0.992382,
      0,
      NULL,
      NULL,
      0.382697,
      NULL,
      NULL,
      0.812246,
      2,
      1,
      0,
      2,
      0.442979,
      1,
      NULL,
      NULL,
      NULL,
      0.077950,
      1.177271,
      0,
      3,
      NULL,
      1.777020,
      1,
      0.525877,
      1.528896,
      NULL,
      1,
      0,
      0,
      0.800715,
      1.386168,
      NULL,
      NULL,
      NULL,
      1,
      1.411483,
      1,
      0,
      NULL,
      NULL,
      0.208155,
      0.880165,
      1,
      0.383866,
      1,
      1,
      0,
      2,
      0.200900,
      NULL,
      NULL,
      NULL,
      1.062760,
      1.336746,
      0,
      NULL,
      NULL,
      4,
      1.765546,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      0.221809,
      0.351484,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.488120,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.769947,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.441068,
      0.267413,
      0,
      NULL,
      0,
      0.215150,
      1,
      1,
      NULL,
      0.063782,
      NULL,
      1.366349,
      NULL,
      0,
      1.117982,
      1,
      1,
      1.478299,
      1,
      1.388823,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.489150,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.720120,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.966006,
      NULL,
      NULL,
      NULL,
      NULL,
      0.919662,
      NULL,
      NULL,
      NULL,
      NULL,
      1.072316,
      0.961284,
      1,
      NULL,
      NULL,
      0.671704,
      1.729749,
      1,
      1.895724,
      '14324',
      '',
      '',
      2.021898,
      '12342',
      NULL,
      '',
      1,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


