set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8816454';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-8-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '2',
      NULL,
      NULL,
      NULL,
      59.208933,
      2,
      3.605144,
      3,
      '402100',
      NULL,
      ' 5-10-1999',
      48.444486,
      NULL,
      1,
      NULL,
      1,
      0.136695,
      NULL,
      1.077596,
      0,
      1,
      0,
      1.419082,
      3.951269,
      0.033480,
      2,
      0.541411,
      0.439874,
      1,
      0,
      1.216489,
      3.705010,
      0,
      NULL,
      0.115175,
      1.303181,
      0.048232,
      5.374992,
      1,
      3.286723,
      NULL,
      0,
      0.879733,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      1,
      1,
      0,
      1.288634,
      0,
      2,
      2.225382,
      0.646546,
      3,
      NULL,
      1,
      1,
      NULL,
      3.987393,
      2,
      2,
      1.706593,
      2,
      3,
      0.629499,
      0.682370,
      6.848475,
      1,
      2,
      NULL,
      1.730138,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      4,
      NULL,
      4,
      0.506016,
      NULL,
      1,
      0,
      1.809559,
      3.068596,
      1.573034,
      0.701647,
      NULL,
      NULL,
      1.002976,
      1,
      NULL,
      0,
      NULL,
      0.934910,
      1.447360,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.034771,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.474192,
      1.499545,
      0.201010,
      0.835131,
      NULL,
      0,
      0.721153,
      NULL,
      7.503095,
      NULL,
      7.453001,
      4,
      NULL,
      1,
      0.909892,
      3,
      1.446608,
      1.075238,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.282380,
      1.862901,
      1,
      0,
      1,
      1.553171,
      1.831316,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.502662,
      NULL,
      8.643449,
      NULL,
      0,
      NULL,
      0,
      1.940758,
      3,
      1.025553,
      3,
      1,
      0,
      0.918314,
      1.935197,
      3,
      NULL,
      4.851875,
      NULL,
      3.595309,
      3,
      1.863918,
      1,
      0.924443,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      1,
      NULL,
      1.078926,
      NULL,
      1.132552,
      0.780747,
      NULL,
      NULL,
      0.327049,
      1.628425,
      0,
      1.659363,
      0.242950,
      0,
      0,
      0.313620,
      1.347505,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.123282,
      0.978574,
      1,
      NULL,
      1.549387,
      1.544535,
      NULL,
      1,
      1.054206,
      NULL,
      NULL,
      NULL,
      NULL,
      1.378268,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.194789,
      1.462347,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.857198,
      NULL,
      '',
      '',
      0,
      '02333',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


