set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8119304';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-12-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '22241121',
      41.714148,
      36,
      NULL,
      2.540148,
      2,
      1.875470,
      3,
      '203440',
      3.102275,
      NULL,
      1,
      37.434168,
      1.247287,
      NULL,
      4.679099,
      2,
      1,
      0,
      3,
      0,
      1,
      1,
      1.697053,
      0,
      NULL,
      0.446205,
      0.620419,
      NULL,
      NULL,
      0.221713,
      NULL,
      1.287097,
      0,
      1,
      1.991747,
      0,
      0.840372,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.615409,
      0.464046,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.207293,
      1.817935,
      1,
      1.728225,
      0,
      0.216752,
      1,
      0.384115,
      1,
      1.640494,
      0,
      NULL,
      0.442879,
      NULL,
      0,
      NULL,
      1.552792,
      1,
      0,
      NULL,
      NULL,
      4,
      NULL,
      1,
      4,
      1.211905,
      5,
      0,
      NULL,
      0,
      2.153430,
      NULL,
      3.663523,
      0.110402,
      1.510762,
      NULL,
      5.267710,
      NULL,
      8.977889,
      1,
      5,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.546286,
      1,
      0,
      0.553743,
      0,
      0,
      1.523693,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      3,
      0.732018,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.353872,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      5.619237,
      NULL,
      0.468855,
      0.318114,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4.070170,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.504066,
      NULL,
      1.240621,
      1.342732,
      1,
      1,
      0,
      0,
      0,
      0.956024,
      NULL,
      0,
      3.907362,
      1.257944,
      0.339405,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.737676,
      1.551746,
      1,
      0,
      0,
      0.309754,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.433450,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.573372,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      NULL,
      1.740480,
      0.761296,
      NULL,
      2,
      4.527768,
      '13431',
      NULL,
      NULL,
      3,
      '1013',
      '',
      '',
      0,
      '',
      NULL,
      NULL,
      NULL,
      0.840185,
      3,
      0.937169,
      2.663812,
      2,
      0,
      3,
      0);
commit;
end;
/


