set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8119304';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-6-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0310',
      '03000201',
      29.052682,
      NULL,
      '2314100',
      16.989581,
      6,
      3.118277,
      1,
      '112441',
      0.773687,
      ' 6-12-1982',
      8.568686,
      22.702037,
      1.022585,
      NULL,
      2.770933,
      1,
      0,
      0.196578,
      3.453151,
      0.112878,
      NULL,
      NULL,
      1,
      1,
      2.976922,
      1.086168,
      1.652689,
      0,
      1.315542,
      0,
      6.546091,
      0,
      NULL,
      NULL,
      1,
      1.023054,
      5,
      1,
      3,
      0.763083,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.983169,
      1.218144,
      0.297292,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.274487,
      1,
      1.189634,
      1.486447,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      4.433150,
      NULL,
      3.405884,
      NULL,
      0,
      1,
      0,
      1.997937,
      1.494162,
      NULL,
      0.902004,
      0,
      0,
      0.623711,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1.450245,
      NULL,
      1.837091,
      0.181934,
      3,
      NULL,
      6.898894,
      1.332077,
      2,
      1,
      4.708810,
      1.925755,
      3.140112,
      NULL,
      6.039422,
      9,
      7,
      0,
      2,
      5,
      4.691805,
      4,
      7.730849,
      3.830353,
      1.796607,
      NULL,
      3.614770,
      NULL,
      1.859859,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.390847,
      1.762153,
      0,
      0,
      0,
      1.477264,
      5.534058,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.167800,
      NULL,
      0.212002,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3.710694,
      2,
      7,
      0.871212,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.464161,
      1.757810,
      3,
      0,
      NULL,
      2.681322,
      1,
      3,
      3.661882,
      NULL,
      0,
      0,
      1.021234,
      0,
      NULL,
      1.009679,
      1,
      3,
      NULL,
      1,
      1.238289,
      1.502847,
      2.599037,
      3.576594,
      2.422323,
      1.909010,
      0.253134,
      1.395747,
      1.812103,
      0,
      0,
      1.317060,
      0,
      NULL,
      0,
      1.057165,
      1,
      0.928872,
      0.640798,
      0.694722,
      0.463844,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.373083,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.123184,
      NULL,
      1.389419,
      NULL,
      0.902942,
      1.138010,
      0.259850,
      NULL,
      5.200477,
      '14114',
      '23210',
      '',
      2.236783,
      '1120',
      '',
      '',
      1.094040,
      '',
      '',
      '',
      1,
      2,
      0,
      NULL,
      0.727819,
      3,
      0.564286,
      NULL,
      0.115838);
commit;
end;
/


