set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8119304';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-1-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4422',
      '01423223',
      36.719568,
      NULL,
      NULL,
      0,
      NULL,
      3,
      1,
      NULL,
      2,
      ' 2- 4-1986',
      47.225207,
      7.769424,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.054668,
      2.679111,
      1,
      4.313283,
      0,
      1,
      0,
      1.933785,
      0.994764,
      NULL,
      0,
      0,
      0.485826,
      NULL,
      0.237808,
      NULL,
      1,
      NULL,
      0.879167,
      1.670994,
      1.070152,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.768094,
      0,
      0.767522,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.708906,
      0.626468,
      NULL,
      1.409112,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.737231,
      6,
      1,
      1.608951,
      1.978011,
      NULL,
      1.504624,
      0.760095,
      0.733450,
      1,
      0.655358,
      1,
      0.816577,
      0.675614,
      0.487714,
      1.372025,
      NULL,
      1.991057,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      4.347567,
      3,
      2.250788,
      NULL,
      NULL,
      3,
      0.772008,
      NULL,
      3,
      4,
      NULL,
      NULL,
      9.438035,
      1.140500,
      2,
      NULL,
      1,
      0.045591,
      0,
      4.274954,
      1,
      NULL,
      NULL,
      8,
      1.147686,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.610058,
      1,
      0,
      1,
      0,
      0,
      1.152328,
      0.743222,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      1.982076,
      NULL,
      0,
      1,
      0,
      0.982268,
      1,
      1.930851,
      NULL,
      0.677584,
      1,
      NULL,
      NULL,
      NULL,
      3.817702,
      2,
      NULL,
      0,
      0.013057,
      2,
      0.672718,
      NULL,
      NULL,
      NULL,
      NULL,
      7.618266,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.759484,
      3,
      0,
      1,
      0.395704,
      NULL,
      3.968574,
      NULL,
      0,
      1.996637,
      1,
      1.392890,
      0,
      1.683923,
      0,
      1.497521,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.601957,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.636310,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.280481,
      1.272093,
      NULL,
      1.801997,
      1,
      0.470164,
      NULL,
      5.467878,
      '22341',
      '34303',
      NULL,
      1,
      NULL,
      '',
      '',
      0,
      '',
      NULL,
      '',
      3.438525,
      NULL,
      1,
      0.747531,
      2.947834,
      0,
      NULL,
      3.692876,
      1.589956);
commit;
end;
/


