set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8119304';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-7-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3242',
      NULL,
      91.461739,
      51.297549,
      '1111011',
      24,
      4,
      NULL,
      2,
      '201224',
      NULL,
      ' 5- 0-2000',
      35.094649,
      49.313343,
      NULL,
      NULL,
      2,
      0.645557,
      0,
      0,
      1,
      1.421184,
      0.369150,
      NULL,
      3.838983,
      0,
      0.341491,
      0,
      0,
      0,
      0,
      1,
      3.343941,
      1.925746,
      0,
      1,
      1,
      0.880202,
      5,
      1,
      NULL,
      1.262465,
      0.506388,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.486236,
      1,
      0.599320,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.683165,
      1.402342,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.491056,
      1,
      5,
      1.498252,
      5.726051,
      1,
      1.076445,
      0.771068,
      0,
      NULL,
      1.610245,
      0.251050,
      0,
      1,
      1.613191,
      NULL,
      1.234846,
      1.114395,
      1,
      NULL,
      0.510427,
      1,
      0.502534,
      NULL,
      1,
      1.583471,
      1,
      1,
      0,
      NULL,
      3.854996,
      5,
      2,
      1,
      0.860257,
      1.730814,
      7,
      5,
      6.964858,
      2.916570,
      7.470659,
      0.064739,
      NULL,
      5,
      NULL,
      5,
      0.986484,
      2.346417,
      0,
      NULL,
      NULL,
      0.141798,
      1.655385,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.667176,
      0.362991,
      0,
      NULL,
      0.054174,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.553349,
      NULL,
      1,
      NULL,
      0,
      0.086380,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.648674,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      5,
      0.248650,
      0,
      1.119029,
      NULL,
      NULL,
      NULL,
      NULL,
      1.203216,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.747999,
      2.848590,
      1.228105,
      2,
      NULL,
      1.939704,
      3,
      1,
      1,
      NULL,
      0.601699,
      1.863809,
      1,
      NULL,
      0,
      0,
      1.115522,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.983393,
      0.971045,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.377245,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.513537,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.626197,
      1.080448,
      NULL,
      0.210996,
      1.526309,
      NULL,
      NULL,
      0,
      '20112',
      '12340',
      NULL,
      NULL,
      '2044',
      '',
      '',
      1.375288,
      '',
      '',
      '',
      3,
      5.728333,
      0.720123,
      5.784099,
      4,
      NULL,
      0,
      0.751804,
      1);
commit;
end;
/


