set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8804022';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-1-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      46.823528,
      '2031232',
      100,
      NULL,
      NULL,
      1,
      NULL,
      5.369438,
      ' 6-27-1997',
      0,
      NULL,
      0,
      NULL,
      0,
      0.149046,
      1.264862,
      0.870920,
      NULL,
      NULL,
      1.527079,
      2,
      0,
      1.849768,
      1.571174,
      0.023766,
      0.788239,
      1,
      1,
      3,
      1,
      NULL,
      1,
      1,
      0.269683,
      NULL,
      1.790504,
      NULL,
      3.000924,
      1.493719,
      1,
      0.673597,
      NULL,
      NULL,
      0.655778,
      NULL,
      NULL,
      0.188156,
      NULL,
      NULL,
      0.796818,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.555335,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.763655,
      1.060304,
      0,
      4,
      2,
      1,
      0.549040,
      NULL,
      0.966578,
      1,
      0.985159,
      NULL,
      1.469925,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.337741,
      0.391089,
      2.783722,
      1.380004,
      0.485271,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      5,
      0.750492,
      1,
      4,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.789684,
      1,
      NULL,
      NULL,
      0.987239,
      NULL,
      NULL,
      8.838336,
      1.123199,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.383580,
      1,
      0,
      1.900120,
      1.859635,
      1.142242,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.614412,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.050167,
      3.378216,
      1.708554,
      0.304322,
      NULL,
      1.191699,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      4,
      0,
      0.510000,
      2,
      0.204337,
      NULL,
      NULL,
      NULL,
      0.938358,
      0.018612,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.718764,
      0.840948,
      1,
      0,
      0,
      3.884429,
      1.629765,
      NULL,
      1.208663,
      0,
      3.770930,
      0,
      0,
      0,
      0.993502,
      1,
      0.734917,
      0.490605,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      4,
      1.520228,
      0.806914,
      2.335878,
      1,
      2.434638,
      1,
      1,
      3.406982);
commit;
end;
/


