set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8804022';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-12-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '302',
      '44342420',
      54,
      3.019218,
      '3240020',
      NULL,
      3,
      2.857229,
      3,
      '311132',
      NULL,
      ' 2-17-1978',
      NULL,
      10.344473,
      0.858288,
      NULL,
      0,
      0.039414,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      2.027419,
      0,
      NULL,
      1,
      0.007234,
      0.726023,
      3,
      0.649457,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0,
      0.266647,
      1.019070,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.364837,
      1.339014,
      2,
      1.558173,
      0.159200,
      1.465350,
      0.325750,
      1.790944,
      1,
      2,
      1,
      1,
      0.130339,
      0.297335,
      1.971076,
      NULL,
      1.791383,
      NULL,
      1.732117,
      1.462390,
      0.554535,
      0.481251,
      1,
      2.501397,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.720176,
      0.049113,
      NULL,
      NULL,
      NULL,
      1,
      1.064903,
      0.728130,
      1.489571,
      5,
      0.479639,
      1.013863,
      1.394643,
      0.229170,
      NULL,
      1.165613,
      NULL,
      NULL,
      6.235831,
      0.978560,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.224584,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.032863,
      NULL,
      NULL,
      NULL,
      NULL,
      1.668245,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.026476,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      NULL,
      5,
      2.546546,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.362210,
      NULL,
      1.715145,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      2,
      0.458756,
      0,
      0.899261,
      0,
      0,
      0.612119,
      0,
      1,
      0.348405,
      0,
      1.593980,
      1.138396,
      0.601801,
      NULL,
      0.554532,
      1,
      0.596998,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.778057,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.059483,
      '41012',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      2.069474,
      3,
      2.197828,
      2,
      NULL,
      0.895895,
      1,
      1,
      NULL);
commit;
end;
/


