set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7837080';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-12-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '044',
      '10140142',
      21.275225,
      65.226915,
      '3104240',
      26.848168,
      NULL,
      1.944657,
      1,
      '313003',
      NULL,
      ' 0-17-1999',
      48.070283,
      NULL,
      1,
      NULL,
      1.679625,
      1,
      1,
      0.906351,
      0.939289,
      1.910568,
      1,
      2.613776,
      1.391409,
      NULL,
      0,
      1.983362,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0,
      1.036420,
      0,
      0.404520,
      0.270484,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.234013,
      0,
      1.292129,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1.910944,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.553026,
      1,
      1,
      1,
      0,
      NULL,
      1.607088,
      1.736211,
      1.083412,
      NULL,
      0,
      0.171384,
      1,
      1.064106,
      NULL,
      0,
      1.030146,
      0,
      1,
      NULL,
      1,
      NULL,
      0.672816,
      NULL,
      NULL,
      1,
      1,
      3.587384,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.492264,
      0.242008,
      1,
      1,
      NULL,
      2.139250,
      0.151990,
      1,
      5.155812,
      7.910293,
      3.138694,
      1,
      1,
      1,
      0.994673,
      NULL,
      NULL,
      5.852943,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1,
      NULL,
      0.120465,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.182699,
      NULL,
      NULL,
      NULL,
      NULL,
      0.714609,
      2.054812,
      NULL,
      0.323225,
      1.275760,
      NULL,
      6.149324,
      2.289371,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      5,
      NULL,
      1.828040,
      1,
      1.555819,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.107140,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1.734572,
      1,
      NULL,
      1.313675,
      1,
      0,
      1,
      NULL,
      0,
      1.609678,
      1,
      0.878028,
      0.624232,
      0.330561,
      1.856145,
      1.190252,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.280000,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.669045,
      NULL,
      NULL,
      NULL,
      NULL,
      '31002',
      '',
      '',
      0,
      '1114',
      '',
      '',
      4.620689,
      5,
      NULL,
      5.326042,
      0.302508,
      0.503084,
      NULL,
      NULL,
      1);
commit;
end;
/


