set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9104727';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-11-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '2',
      NULL,
      NULL,
      '4233411',
      3,
      5,
      3,
      0,
      '212442',
      3,
      ' 8-15-1998',
      3.618952,
      NULL,
      1.729025,
      NULL,
      1,
      1.070316,
      1.487196,
      0.390674,
      0,
      0,
      0.717531,
      1.075863,
      1,
      1,
      NULL,
      NULL,
      0,
      7,
      1,
      NULL,
      1.807186,
      1.369468,
      3,
      0,
      6,
      NULL,
      6.428898,
      1,
      1,
      NULL,
      0.165315,
      0.443327,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.506625,
      0,
      0.573500,
      2,
      1.598058,
      1.739231,
      1.825732,
      0.854718,
      1,
      3.591571,
      0.829606,
      3.275348,
      0.910429,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.468214,
      NULL,
      0,
      6.070667,
      1,
      1,
      1,
      1.059174,
      NULL,
      NULL,
      1.911626,
      NULL,
      NULL,
      1.644310,
      0.867390,
      1,
      1.676674,
      0.493075,
      0.762739,
      1,
      0.899540,
      1.024111,
      0.408665,
      0,
      0.283149,
      0.061851,
      1,
      1.910282,
      0,
      0,
      0.203012,
      1,
      NULL,
      0.572239,
      NULL,
      NULL,
      1,
      4.441016,
      0,
      NULL,
      0,
      4,
      1,
      2.200477,
      1,
      1,
      1.978271,
      0.814233,
      5.952896,
      0,
      NULL,
      NULL,
      6,
      9,
      3.371485,
      2.512649,
      4,
      NULL,
      NULL,
      10,
      5,
      3,
      1,
      1.689630,
      0.074330,
      0.227371,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      1.395930,
      NULL,
      0.454022,
      0.320642,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.595818,
      NULL,
      5,
      3.488836,
      1,
      0.927404,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      3.165531,
      0.643753,
      NULL,
      NULL,
      NULL,
      1.105341,
      0.442306,
      5,
      NULL,
      1,
      1,
      4,
      0.749923,
      NULL,
      NULL,
      1,
      0,
      0.806258,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.152402,
      1,
      0,
      2,
      NULL,
      0,
      NULL,
      0,
      2,
      1,
      0,
      0.839263,
      1.306946,
      1,
      0.534656,
      0.578810,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.389963,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      '',
      NULL,
      0,
      '',
      NULL,
      '',
      1,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


