set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9104727';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-3-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '0',
      NULL,
      NULL,
      '2313231',
      2,
      3,
      0.850723,
      1,
      '130003',
      1.363518,
      NULL,
      21.826660,
      NULL,
      0.314602,
      NULL,
      0.754523,
      0.417900,
      3,
      0,
      1.156447,
      1.159992,
      0.501177,
      1,
      0.572796,
      0.522182,
      7,
      0,
      1.033653,
      2,
      0,
      NULL,
      NULL,
      0.772070,
      6,
      NULL,
      NULL,
      4.610015,
      2.278291,
      NULL,
      1,
      0,
      NULL,
      0.184345,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.952403,
      3.445440,
      1.965956,
      2.531059,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.616229,
      0.844231,
      0.683037,
      1,
      0.824652,
      0,
      NULL,
      0,
      2,
      4.748117,
      5.432217,
      0,
      NULL,
      0.347835,
      1.149471,
      NULL,
      NULL,
      1.721130,
      NULL,
      NULL,
      1,
      1.040125,
      1.944970,
      NULL,
      0,
      1,
      0.130748,
      1,
      0.432724,
      0.889174,
      NULL,
      NULL,
      1,
      1.717638,
      0,
      0.605270,
      0.075601,
      0.621699,
      1,
      NULL,
      0,
      5.176090,
      3,
      NULL,
      4.112449,
      1.158306,
      NULL,
      1,
      5.014089,
      1,
      5,
      0,
      2.711727,
      4,
      NULL,
      NULL,
      1.048700,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.064991,
      2,
      3.656758,
      5.183433,
      NULL,
      NULL,
      1,
      0.490213,
      1.778151,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.465214,
      0,
      2,
      1,
      NULL,
      1,
      1.054736,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      6,
      2.309378,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.996392,
      0.134776,
      NULL,
      NULL,
      NULL,
      1.152510,
      0,
      1.239027,
      1.075303,
      1,
      1,
      0.075236,
      0,
      NULL,
      NULL,
      1.235286,
      4,
      1.099045,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.393983,
      2,
      1.314868,
      0.517728,
      3,
      3.846600,
      3,
      2,
      0.906051,
      NULL,
      1.344584,
      NULL,
      0.035039,
      1.108104,
      0,
      1,
      0,
      NULL,
      0,
      0.300136,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.263271,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.509087,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.718850,
      NULL,
      0,
      1,
      1,
      0,
      0.403816,
      '24432',
      '',
      NULL,
      0.816125,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


