set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9104727';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-4-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      NULL,
      NULL,
      NULL,
      '4213244',
      NULL,
      3,
      0.881115,
      0,
      '441343',
      1.544852,
      ' 9-13-1996',
      9,
      NULL,
      1,
      NULL,
      1.046081,
      1.598920,
      NULL,
      1.067348,
      0.018923,
      1.926347,
      1,
      0,
      1.669396,
      1,
      3.192521,
      NULL,
      0.962757,
      1.521498,
      0,
      1,
      NULL,
      0.834446,
      3.985351,
      NULL,
      1.269636,
      1,
      2,
      0,
      4,
      2,
      1,
      0.801048,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      9,
      4.905283,
      3.711545,
      NULL,
      0,
      0.367255,
      0.087091,
      3.465412,
      NULL,
      NULL,
      NULL,
      1,
      1.761318,
      1,
      NULL,
      NULL,
      2.054276,
      2,
      2,
      0.588738,
      0.780833,
      1.460944,
      6.229731,
      1,
      1,
      3,
      1.454128,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      0,
      1,
      0.556394,
      1.759720,
      NULL,
      1.320653,
      0,
      0.990447,
      0,
      0.750971,
      0.812032,
      0.284252,
      NULL,
      0,
      0,
      NULL,
      0.402407,
      5.276255,
      0.070342,
      1,
      NULL,
      1.693014,
      NULL,
      1.065512,
      5.273628,
      1.114525,
      NULL,
      NULL,
      0,
      0.744747,
      3,
      NULL,
      1.540485,
      5,
      6.610345,
      8,
      0.387657,
      2.578938,
      0,
      4,
      6,
      3,
      1,
      5.922860,
      2.690317,
      1.569794,
      0.757703,
      2,
      0.131940,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      NULL,
      NULL,
      0.912716,
      1,
      0.421921,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.980328,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.897605,
      1,
      1.696152,
      0,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.483541,
      1,
      0.874658,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.472126,
      1,
      1.283853,
      0.721425,
      NULL,
      NULL,
      1,
      0,
      0.237427,
      1,
      1,
      0.315957,
      NULL,
      0,
      0.831605,
      1.113871,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.253469,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.000786,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.129690,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.314432,
      1,
      NULL,
      0,
      0,
      0.713127,
      0,
      0,
      '02430',
      '',
      '',
      1.492592,
      '',
      '',
      '',
      1.312834,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


