set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9104727';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-9-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '1',
      NULL,
      NULL,
      '1141141',
      NULL,
      NULL,
      3.484823,
      0,
      '102113',
      NULL,
      ' 7- 6-1996',
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.581264,
      1,
      1,
      NULL,
      0,
      0.515182,
      0.176168,
      3.045521,
      1.057492,
      0,
      1,
      1,
      0,
      0,
      NULL,
      2.207998,
      0,
      0.563343,
      1.123508,
      3,
      1.935517,
      0.516196,
      1,
      2,
      2,
      1.568361,
      1.659612,
      NULL,
      NULL,
      1.324030,
      NULL,
      NULL,
      0.411568,
      0.217417,
      1.280489,
      0.852480,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.188860,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.917061,
      NULL,
      0.278923,
      1.278566,
      0,
      NULL,
      0.153023,
      1,
      1,
      NULL,
      0.776254,
      1,
      NULL,
      0.885959,
      1,
      0.698873,
      1,
      1,
      NULL,
      0.186177,
      NULL,
      1.815959,
      1.641079,
      1,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      0.806840,
      1,
      1.600342,
      2.069854,
      3,
      0.302568,
      7,
      2.149382,
      NULL,
      7,
      0.640146,
      NULL,
      2,
      7,
      0.933614,
      0,
      1.705095,
      0.982452,
      NULL,
      NULL,
      1.483199,
      0.019560,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.766551,
      2,
      0,
      1,
      1.240539,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.575232,
      NULL,
      NULL,
      NULL,
      NULL,
      1.993559,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.504341,
      0.228167,
      NULL,
      1.469489,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.715780,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.015110,
      NULL,
      0,
      0,
      NULL,
      NULL,
      3.255275,
      1.019379,
      0.489621,
      2,
      NULL,
      1.826588,
      1,
      1,
      1,
      1,
      0,
      1.077289,
      0.609982,
      1.700943,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '03323',
      NULL,
      '',
      1,
      '',
      '',
      NULL,
      1.862243,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


