set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9104727';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-3-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '122',
      NULL,
      26,
      16,
      '4000441',
      98,
      5,
      3.321655,
      3,
      '033422',
      5.649093,
      ' 5- 9-1989',
      NULL,
      31.178659,
      0.404548,
      NULL,
      1.812196,
      0.480979,
      1,
      0,
      1,
      0,
      1.371269,
      2,
      0,
      1.325526,
      1,
      1,
      0.226478,
      3.222291,
      0.854721,
      1,
      1.578623,
      NULL,
      1,
      0,
      0,
      0.754326,
      4,
      1,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.773728,
      1.360626,
      1.572035,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.360056,
      0.142327,
      0.810823,
      NULL,
      NULL,
      1.259911,
      1.927656,
      1.545631,
      0.128441,
      NULL,
      0.446037,
      1,
      NULL,
      NULL,
      0.027090,
      1,
      1.997194,
      0,
      NULL,
      1.687775,
      1.149364,
      1,
      1,
      1.075589,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.704329,
      0,
      1,
      NULL,
      0,
      0,
      0,
      0.532086,
      7,
      3,
      NULL,
      1,
      1.804672,
      0,
      1.091707,
      0.790500,
      0,
      NULL,
      NULL,
      NULL,
      1.015669,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.024091,
      1,
      1,
      1,
      0,
      0.690096,
      1.743117,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.991249,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1.699404,
      4.526282,
      2.473741,
      0,
      NULL,
      NULL,
      NULL,
      1.264341,
      NULL,
      0,
      0,
      0,
      0,
      1.875167,
      NULL,
      NULL,
      NULL,
      1.882701,
      1,
      0.863197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.520078,
      0,
      NULL,
      0.572128,
      1,
      0.212327,
      1,
      1,
      1,
      NULL,
      1,
      1,
      1.379487,
      1.356532,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.764398,
      '20034',
      '',
      '',
      0.993588,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      NULL,
      4,
      3.321335,
      1,
      2,
      3.388849,
      3.370658,
      NULL,
      1.297882,
      5);
commit;
end;
/


