set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9104727';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-9-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '124',
      '31142420',
      57.235614,
      NULL,
      '1004413',
      98,
      3,
      0.570508,
      1,
      NULL,
      2,
      ' 0-28-1989',
      17.571231,
      NULL,
      1.780124,
      NULL,
      1,
      1,
      0.928713,
      1,
      1.298258,
      NULL,
      1.478429,
      0.539297,
      1,
      NULL,
      0,
      0.702864,
      0,
      5,
      0.448929,
      1.767786,
      NULL,
      0,
      0,
      1,
      3.103437,
      NULL,
      5,
      0,
      0,
      1.744957,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.195862,
      0,
      0,
      1.464930,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.717869,
      0.216203,
      0.006305,
      1,
      0,
      NULL,
      1.685925,
      0,
      0.426204,
      0,
      0,
      NULL,
      1,
      0,
      0.144776,
      NULL,
      0,
      0.820403,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.743949,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.813466,
      1.905392,
      1.546956,
      1,
      NULL,
      NULL,
      2.948072,
      2,
      0,
      6.538165,
      4.543898,
      NULL,
      1.956943,
      1,
      0.623487,
      NULL,
      NULL,
      9.217539,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.966367,
      1,
      1,
      NULL,
      1.506687,
      0,
      0.830900,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.489953,
      NULL,
      NULL,
      NULL,
      NULL,
      0.286785,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      1.189106,
      NULL,
      NULL,
      NULL,
      1,
      0.671492,
      1.705308,
      NULL,
      1,
      0,
      0.331380,
      NULL,
      NULL,
      NULL,
      1,
      1.079563,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.067353,
      1,
      NULL,
      1,
      0.642672,
      0.415504,
      0.392689,
      0,
      NULL,
      3.190196,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.161577,
      0,
      1.916501,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.954138,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      '',
      NULL,
      0,
      NULL,
      '',
      '',
      1.368860,
      '',
      '',
      NULL,
      5,
      2.368744,
      2,
      0,
      1,
      3,
      1,
      0.022215,
      1.233891);
commit;
end;
/


