set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9104727';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-3-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '00103014',
      22.609112,
      41,
      '4331013',
      24.636110,
      NULL,
      NULL,
      2,
      '223432',
      5,
      ' 4-19-1991',
      1.365922,
      19.558470,
      0.046661,
      NULL,
      NULL,
      0,
      2,
      1.992387,
      NULL,
      1.166978,
      0,
      1,
      1,
      NULL,
      0.978026,
      NULL,
      1,
      5,
      0,
      NULL,
      0,
      NULL,
      4.636046,
      1.295011,
      3,
      NULL,
      0.849107,
      1,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.584986,
      NULL,
      1.249500,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.445583,
      0.583792,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.030798,
      NULL,
      0.090120,
      0.957628,
      1.999733,
      NULL,
      0,
      NULL,
      1.812133,
      1.324308,
      0,
      1.315462,
      1,
      0.838490,
      1.084221,
      1,
      1.484306,
      1.037736,
      NULL,
      NULL,
      1,
      1.085337,
      0,
      NULL,
      1,
      1.990823,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.929057,
      1,
      0,
      1.374286,
      0,
      1,
      0.916849,
      NULL,
      5,
      NULL,
      4.627667,
      2.207676,
      4.623167,
      0.703443,
      0.504079,
      NULL,
      1.413039,
      NULL,
      NULL,
      5,
      1.980993,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.160843,
      1.188539,
      0,
      0,
      1.060693,
      1,
      1.994569,
      1.268091,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.729757,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.888295,
      NULL,
      0.980797,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.400186,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.574272,
      0.606472,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1.066128,
      1,
      1,
      0.100740,
      1.210880,
      1.608614,
      2,
      1,
      0,
      NULL,
      1,
      NULL,
      0.553701,
      0.831682,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '20422',
      '',
      '',
      0,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '',
      NULL,
      1.119439,
      1.158990,
      0,
      NULL,
      2,
      NULL,
      3,
      0);
commit;
end;
/


